/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.entity.thrown;

import com.sammy.malum.common.item.food.ConcentratedGluttonyItem;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.entity.MalumEntities;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.rendering.trail.TrailPointBuilder;

public class ThrownConcentratedGluttony
extends ThrowableItemProjectile {
    protected static final EntityDataAccessor<Boolean> DATA_FADING_AWAY = SynchedEntityData.defineId(ThrownConcentratedGluttony.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final List<TrailPointBuilder> trails = new ArrayList<TrailPointBuilder>(List.of(TrailPointBuilder.create((int)4), TrailPointBuilder.create((int)8), TrailPointBuilder.create((int)12)));
    public float spinOffset = (float)((double)this.random.nextFloat() * Math.PI * 2.0);
    public int age;
    public int fadingTimer;

    public ThrownConcentratedGluttony(Level pLevel) {
        super((EntityType)MalumEntities.THROWN_GLUTTONY.get(), pLevel);
    }

    public ThrownConcentratedGluttony(Level pLevel, LivingEntity pShooter) {
        super((EntityType)MalumEntities.THROWN_GLUTTONY.get(), pShooter, pLevel);
    }

    public ThrownConcentratedGluttony(Level pLevel, double pX, double pY, double pZ) {
        super((EntityType)MalumEntities.THROWN_GLUTTONY.get(), pX, pY, pZ, pLevel);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_FADING_AWAY, (Object)false);
        super.defineSynchedData(builder);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        if (DATA_FADING_AWAY.equals(pKey) && this.isFadingAway()) {
            this.setDeltaMovement(this.getDeltaMovement().scale((double)0.02f));
        }
        super.onSyncedDataUpdated(pKey);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        if (this.age != 0) {
            compound.putInt("age", this.age);
        }
        if (((Boolean)this.entityData.get(DATA_FADING_AWAY)).booleanValue()) {
            compound.putBoolean("fadingAway", true);
            compound.putInt("fadingTimer", this.fadingTimer);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.age = compound.getInt("age");
        this.getEntityData().set(DATA_FADING_AWAY, (Object)compound.getBoolean("fadingAway"));
    }

    protected Item getDefaultItem() {
        return (Item)MalumItems.SPLASH_OF_GLUTTONY.get();
    }

    public void tick() {
        super.tick();
        boolean fadingAway = this.isFadingAway();
        if (this.level().isClientSide) {
            for (int i = 0; i < 3; ++i) {
                TrailPointBuilder trailPointBuilder = this.trails.get(i);
                float offsetScale = (float)i * 0.1f;
                if (fadingAway) {
                    offsetScale *= 1.0f + (float)this.fadingTimer / 4.0f;
                }
                for (int j = 0; j < 2; ++j) {
                    float progress = (float)(j + 1) * 0.5f;
                    Vec3 position = this.getPosition(progress);
                    float scalar = ((float)i * 2.35f + (float)this.age + progress) / 2.0f;
                    double xOffset = Math.cos(this.spinOffset + scalar) * (double)offsetScale;
                    double zOffset = Math.sin(this.spinOffset + scalar) * (double)offsetScale;
                    trailPointBuilder.addTrailPoint(position.add(xOffset, 0.0, zOffset));
                }
                trailPointBuilder.tickTrailPoints();
            }
        }
        ++this.age;
        if (fadingAway) {
            ++this.fadingTimer;
            if (this.fadingTimer >= 40) {
                this.discard();
            }
        }
    }

    protected void onHit(HitResult pResult) {
        Entity entity;
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (this.isFadingAway()) {
            return;
        }
        if (pResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)pResult;
            entity = entityHitResult.getEntity();
        } else {
            entity = null;
        }
        Entity impactedEntity = entity;
        this.getEntityData().set(DATA_FADING_AWAY, (Object)true);
        this.setDeltaMovement(this.getDeltaMovement().scale((double)0.05f));
        this.setNoGravity(true);
        level2.levelEvent(2002, this.blockPosition(), ((MobEffect)MalumMobEffects.GLUTTONY.get()).getColor());
        level2.playSound(null, this.blockPosition(), (SoundEvent)MalumSoundEvents.CONCENTRATED_GLUTTONY_DRINK.get(), SoundSource.PLAYERS, 0.5f, 1.25f + level2.random.nextFloat() * 0.25f);
        MalumParticleEffectTypes.THROWN_GLUTTONY_IMPACT.createEffect(this.position()).spawn(level2);
        this.applyGluttony(level2, impactedEntity);
        super.onHit(pResult);
    }

    private void applyGluttony(ServerLevel level, @Nullable Entity impactedEntity) {
        List targets = level.getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(3.0, 2.0, 3.0));
        if (!targets.isEmpty()) {
            for (LivingEntity target : targets) {
                double distance;
                if (!target.isAffectedByPotions() || !((distance = this.distanceToSqr((Entity)target)) < 6.0)) continue;
                float durationScalar = target.equals((Object)impactedEntity) ? 1.0f : (float)(1.0 - Math.sqrt(distance) / 4.0);
                ConcentratedGluttonyItem.applyConcentratedGluttonyEffect(target, durationScalar);
                ConcentratedGluttonyItem.createGluttonyVFX(level, target, 0.25f);
            }
        }
    }

    public boolean isFadingAway() {
        return (Boolean)this.entityData.get(DATA_FADING_AWAY);
    }

    public float getVisualEffectScalar() {
        float effectScalar = 1.0f;
        if (this.age < 5) {
            effectScalar = (float)this.age / 5.0f;
        } else if (this.isFadingAway()) {
            effectScalar = effectScalar * (float)(40 - this.fadingTimer) / 40.0f;
        }
        return effectScalar;
    }
}

