/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.oath.deliverance;

import com.google.common.collect.Multimap;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.MalignantCritEvent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumAttributes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.event.tick.EntityTickEvent;

public class UndiscernedMawGeas
extends GeasEffect {
    private int timer;
    private int streak;

    public UndiscernedMawGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.OATH_OF_THE_UNDISCERNED_MAW.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("malignant_crit_leech", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("malignant_crit_healing_overexertion", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (this.streak > 0) {
            ++this.timer;
            if (this.timer > 1200) {
                this.streak = 0;
                this.setDirty();
            }
        }
    }

    @Override
    public Multimap<Holder<Attribute>, AttributeModifier> createAttributeModifiers(LivingEntity entity, Multimap<Holder<Attribute>, AttributeModifier> modifiers) {
        if (this.streak > 3) {
            this.addAttributeModifier(modifiers, (Holder<Attribute>)MalumAttributes.HEALING_MULTIPLIER, -0.05f * (float)(this.streak - 3), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        }
        return modifiers;
    }

    @Override
    public void finalizedMalignantCritEvent(MalignantCritEvent.Post event, LivingEntity attacker) {
        float amount = event.getNewDamage() / Math.max(event.getOriginalDamage(), 0.01f);
        LivingEntity livingEntity = event.getLivingEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.causeFoodExhaustion(0.5f * amount);
        }
        attacker.heal(amount);
        ++this.streak;
        this.timer /= 2;
        if (this.streak > 3) {
            this.setDirty();
        }
    }
}

