/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.infernal;

import com.sammy.malum.core.handlers.SoulHarvestHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.CollectSpiritEvent;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumMobEffects;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.geas.WyrdReconstructionReviveParticleEffect;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class WyrdReconstructionGeas
extends GeasEffect {
    private static final int COOLDOWN_DURATION = 48000;
    private static final int TRIGGERS = 12;
    public int spiritCollectionActivations;
    public int delay;

    public WyrdReconstructionGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_WYRD_RECONSTRUCTION.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("wyrd_reconstruction", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("wyrd_reconstruction_spirits", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("wyrd_reconstruction_cooldown", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("spirits_hunger", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    @Override
    public void spiritCollectionEvent(CollectSpiritEvent event, LivingEntity collector, double arcaneResonance) {
        if (collector instanceof Player) {
            Player player = (Player)collector;
            player.causeFoodExhaustion(0.6f);
        }
    }

    @Override
    public void update(EntityTickEvent.Pre event, LivingEntity entity) {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (this.spiritCollectionActivations > 0 && this.delay == 0) {
            SoulHarvestHandler.triggerSpiritCollection(entity);
            this.delay = 2;
            --this.spiritCollectionActivations;
            if (this.spiritCollectionActivations == 0) {
                entity.addEffect(new MobEffectInstance(MalumMobEffects.WYRD_EXHAUSTION, 48000, 0, true, true));
            }
        }
    }

    public void incomingDeathEvent(LivingDeathEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        DamageSource source = event.getSource();
        if (source.is(Tags.DamageTypes.IS_TECHNICAL)) {
            return;
        }
        if (source.is(MalumDamageTypes.VOID)) {
            return;
        }
        if (target.hasEffect(MalumMobEffects.WYRD_EXHAUSTION)) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (this.delay > 0) {
            event.setCanceled(true);
            target.setHealth(1.0f);
            return;
        }
        float health = RandomHelper.randomBetween((RandomSource)target.getRandom(), (float)1.0f, (float)(target.getMaxHealth() * 0.66f));
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (Entity knockbackTarget : serverLevel.getEntities((Entity)target, target.getBoundingBox().inflate(2.0), t -> WyrdReconstructionGeas.canApplyKnockback(target, t))) {
                knockbackTarget.setDeltaMovement(knockbackTarget.position().subtract(target.position()).normalize().scale(2.0).add(0.0, 0.5, 0.0));
            }
            SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)MalumSoundEvents.WYRD_RECONSTRUCTION.get()), (float)1.0f, (float)1.0f);
            MalumParticleEffectTypes.WYRD_RECONSTRUCTION_REVIVE.createEffect((Entity)target).color(new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT)).customData(new WyrdReconstructionReviveParticleEffect.WyrdReconstructionEffectData(target.getId())).spawn(serverLevel);
        }
        this.delay = 15;
        this.spiritCollectionActivations = 12;
        event.setCanceled(true);
        target.setHealth(health);
    }

    protected static boolean canApplyKnockback(LivingEntity attacker, Entity pTarget) {
        TamableAnimal tamableAnimal;
        if (pTarget instanceof TamableAnimal && (tamableAnimal = (TamableAnimal)pTarget).isTame()) {
            return false;
        }
        if (!pTarget.canBeHitByProjectile()) {
            return false;
        }
        return pTarget != attacker && !attacker.isPassengerOfSameVehicle(pTarget);
    }
}

