/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.wicked;

import com.sammy.malum.common.entity.scythe.ScytheBoomerangEntity;
import com.sammy.malum.common.item.curiosities.weapons.scythe.MalumScytheItem;
import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.handlers.SoulDataHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.enchantment.EnchantmentKeys;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class ReaperGeas
extends GeasEffect {
    public ReaperGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_REAPER.get());
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("scythe_combo", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("only_scythe", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            DamageSource source = event.getSource();
            ItemStack heldItem = attacker.getMainHandItem();
            if (!heldItem.isEmpty() && (source.is(DamageTypes.PLAYER_ATTACK) || source.is(MalumDamageTypes.TYRVING))) {
                event.setNewDamage(event.getNewDamage() * 0.1f);
                if (heldItem.isDamageableItem()) {
                    heldItem.hurtAndBreak(10, attacker, EquipmentSlot.MAINHAND);
                }
                return;
            }
            boolean canSweep = MalumScytheItem.canSweep(attacker);
            if (source.is(MalumDamageTypes.SCYTHE_COMBO)) {
                ItemStack scytheStack = SoulDataHandler.getScytheWeapon(source, attacker);
                WeaponParticleEffectType.WeaponParticleEffectBuilder particle = MalumParticleEffectTypes.SCYTHE_SLASH.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).tiedToTarget().forwardOffset(-2.0f).color(scytheStack.getItem()).mirroredRandomly(attacker.getRandom());
                if (canSweep) {
                    int sweeping = EnchantmentKeys.getEnchantmentLevel((Level)level2, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE, stack);
                    float damage = event.getNewDamage() * (0.66f + (float)sweeping * 0.33f);
                    float radius = 1.5f + (float)sweeping * 0.25f;
                    level2.getEntities((Entity)attacker, target.getBoundingBox().inflate((double)radius)).forEach(e -> {
                        LivingEntity sweepTarget;
                        if (e instanceof LivingEntity && (sweepTarget = (LivingEntity)e).isAlive() && sweepTarget != target) {
                            sweepTarget.hurt(DamageTypeHelper.create((Level)level2, MalumDamageTypes.SCYTHE_SWEEP, (Entity)attacker), damage);
                            sweepTarget.knockback((double)0.4f, (double)Mth.sin((float)(attacker.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(attacker.getYRot() * ((float)Math.PI / 180)))));
                        }
                    });
                } else {
                    particle.verticalSlashRotation();
                }
                particle.spawn(level2);
                return;
            }
            if (source.is(MalumTags.DamageTypeTags.IS_SCYTHE)) {
                float magicDamage;
                float physicalDamage;
                float chance = 0.3f;
                int extraHits = 2;
                Entity entity = source.getDirectEntity();
                if (entity instanceof ScytheBoomerangEntity) {
                    ScytheBoomerangEntity scytheBoomerang = (ScytheBoomerangEntity)entity;
                    physicalDamage = scytheBoomerang.damage;
                    magicDamage = scytheBoomerang.magicDamage;
                    chance *= 2.0f;
                } else {
                    physicalDamage = (float)attacker.getAttribute(Attributes.ATTACK_DAMAGE).getValue();
                    magicDamage = (float)attacker.getAttribute((Holder)LodestoneAttributes.MAGIC_DAMAGE).getValue();
                }
                float average = (physicalDamage + magicDamage) / 2.0f;
                physicalDamage *= physicalDamage / average * 0.1f;
                magicDamage *= magicDamage / average * 0.1f;
                if (!canSweep) {
                    ++extraHits;
                    chance += 0.1f;
                }
                if (level2.getRandom().nextFloat() > chance) {
                    return;
                }
                for (int i = 0; i < extraHits; ++i) {
                    int delay = 4 + i * 3;
                    WorldEventHandler.addWorldEvent((Level)level2, (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker, source.getDirectEntity()).setDamageData(physicalDamage, magicDamage, delay).setPhysicalDamageType(MalumDamageTypes.SCYTHE_COMBO).setSound((Holder<SoundEvent>)MalumSoundEvents.REAPER_CUT, 0.9f, 1.1f, 1.0f));
                }
            }
        }
    }
}

