/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.geas.pact.wicked;

import com.sammy.malum.common.worldevent.DelayedDamageWorldEvent;
import com.sammy.malum.core.handlers.GeasEffectHandler;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.geas.GeasEffect;
import com.sammy.malum.core.systems.geas.GeasEffectType;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumGeasEffectTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import team.lodestar.lodestone.handlers.WorldEventHandler;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectType;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;

public class WarlockGeas
extends GeasEffect {
    public WarlockGeas() {
        super((GeasEffectType)MalumGeasEffectTypes.PACT_OF_THE_WARLOCK.get());
    }

    public static void increaseDetection(LivingEvent.LivingVisibilityEvent event) {
        if (GeasEffectHandler.hasGeasEffect(event.getEntity(), MalumGeasEffectTypes.PACT_OF_THE_WARLOCK)) {
            event.modifyVisibility(2.0);
        }
    }

    public void outgoingDamageEvent(LivingDamageEvent.Pre event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        if (target.level().isClientSide) {
            return;
        }
        if (event.getSource().is(MalumDamageTypes.WARLOCK_SPIRIT_IMPACT)) {
            return;
        }
        if (target.getHealth() > target.getMaxHealth() * 0.95f) {
            WorldEventHandler.addWorldEvent((Level)target.level(), (WorldEventInstance)new DelayedDamageWorldEvent((Entity)target).setAttacker((Entity)attacker).setDamageData(0.0f, 4.0f, 3).setMagicDamageType(MalumDamageTypes.WARLOCK_SPIRIT_IMPACT).setImpactParticleEffect((NetworkedParticleEffectType)MalumParticleEffectTypes.WARLOCK_IMPACT, new MalumNetworkedParticleEffectColorData(MalumSpiritTypes.WICKED_SPIRIT)).setSound((Holder<SoundEvent>)MalumSoundEvents.WARLOCK_BLAST, 1.5f, 1.75f, 1.0f));
        }
    }

    @Override
    public void addTooltipComponents(LivingEntity entity, Consumer<Component> tooltipAcceptor, TooltipFlag tooltipFlag) {
        tooltipAcceptor.accept(ComponentHelper.positiveGeasEffect("first_hit_bonus", new Object[0]));
        tooltipAcceptor.accept(ComponentHelper.negativeGeasEffect("aggressive_enemies", new Object[0]));
        super.addTooltipComponents(entity, tooltipAcceptor, tooltipFlag);
    }
}

