/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities;

import com.sammy.malum.common.data.component.SoulwovenPouchContentsComponent;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import org.apache.commons.lang3.math.Fraction;
import team.lodestar.lodestone.helpers.SoundHelper;

public class SoulwovenPouchItem
extends Item {
    private static final int BAR_COLOR = Mth.color((float)0.4f, (float)0.4f, (float)1.0f);

    public SoulwovenPouchItem(Item.Properties properties) {
        super(properties.component(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY));
    }

    public static float getFullnessDisplay(ItemStack stack) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.getOrDefault(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
        return contents.weight().floatValue();
    }

    public static void trySwallowItem(ItemEntityPickupEvent.Pre event) {
        if (event.canPickup().isFalse()) {
            return;
        }
        ItemEntity itemEntity = event.getItemEntity();
        if (itemEntity.hasPickUpDelay()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack pickedUp = itemEntity.getItem();
        if (!pickedUp.is(MalumTags.ItemTags.SOULWOVEN_POUCH_AUTOCOLLECT)) {
            return;
        }
        for (NonNullList playerInventory : player.getInventory().compartments) {
            for (ItemStack item : playerInventory) {
                if (!item.has(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS) || player.getCooldowns().isOnCooldown(item.getItem())) continue;
                SoulwovenPouchItem.trySwallowItem(player, item, pickedUp);
            }
        }
    }

    public static void trySwallowItem(Player player, ItemStack stack, ItemStack pickedUp) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.get(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
        if (contents != null) {
            Item item;
            SoulwovenPouchContentsComponent.Mutable mutable = new SoulwovenPouchContentsComponent.Mutable(contents);
            int i = mutable.tryInsert(pickedUp);
            if (i > 0 && (item = stack.getItem()) instanceof SoulwovenPouchItem) {
                SoulwovenPouchItem pouch = (SoulwovenPouchItem)item;
                pouch.playInsertSound((Entity)player);
            }
            stack.set(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)mutable.toImmutable());
        }
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        int i;
        if (stack.getCount() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.get(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
        if (contents == null) {
            return false;
        }
        ItemStack itemstack = slot.getItem();
        SoulwovenPouchContentsComponent.Mutable mutable = new SoulwovenPouchContentsComponent.Mutable(contents);
        if (itemstack.isEmpty()) {
            this.playRemoveOneSound((Entity)player);
            ItemStack tryRemove = mutable.removeOne();
            if (tryRemove != null) {
                ItemStack removed = slot.safeInsert(tryRemove);
                mutable.tryInsert(removed);
            }
        } else if (itemstack.getItem().canFitInsideContainerItems() && (i = mutable.tryTransfer(slot, player)) > 0) {
            this.playInsertSound((Entity)player);
        }
        stack.set(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)mutable.toImmutable());
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.get(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
            if (contents == null) {
                return false;
            }
            SoulwovenPouchContentsComponent.Mutable mutable = new SoulwovenPouchContentsComponent.Mutable(contents);
            if (other.isEmpty()) {
                ItemStack removed = mutable.removeOne();
                if (removed != null) {
                    this.playRemoveOneSound((Entity)player);
                    access.set(removed);
                }
            } else {
                int i = mutable.tryInsert(other);
                if (i > 0) {
                    this.playInsertSound((Entity)player);
                }
            }
            stack.set(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)mutable.toImmutable());
            return true;
        }
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemstack = player.getItemInHand(usedHand);
        if (SoulwovenPouchItem.dropContents(itemstack, player)) {
            this.playDropContentsSound((Entity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            player.getCooldowns().addCooldown(itemstack.getItem(), 200);
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public boolean isBarVisible(ItemStack stack) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.getOrDefault(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
        return contents.weight().compareTo(Fraction.ZERO) > 0;
    }

    public int getBarWidth(ItemStack stack) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.getOrDefault(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
        return Math.min(1 + Mth.mulAndTruncate((Fraction)contents.weight(), (int)12), 13);
    }

    public int getBarColor(ItemStack stack) {
        return BAR_COLOR;
    }

    private static boolean dropContents(ItemStack stack, Player player) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.get(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
        if (contents != null && !contents.isEmpty()) {
            stack.set(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
            if (player instanceof ServerPlayer) {
                contents.itemsCopy().forEach(item -> player.drop(item, true));
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((TooltipComponent)stack.get(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS)) : Optional.empty();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)stack.get(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
        if (contents != null) {
            int i = Mth.mulAndTruncate((Fraction)contents.weight(), (int)512);
            tooltipComponents.add((Component)Component.translatable((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{i, 512}).withStyle(ChatFormatting.GRAY));
        }
    }

    public void onDestroyed(ItemEntity itemEntity) {
        SoulwovenPouchContentsComponent contents = (SoulwovenPouchContentsComponent)itemEntity.getItem().get(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS);
        if (contents != null) {
            itemEntity.getItem().set(MalumDataComponents.SOULWOVEN_POUCH_CONTENTS, (Object)SoulwovenPouchContentsComponent.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, contents.itemsCopy());
        }
    }

    public void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public void playInsertSound(Entity entity) {
        if (!entity.level().isClientSide) {
            SoundHelper.playSound((Entity)entity, (SoundEvent)SoundEvents.BUNDLE_INSERT, (float)0.8f, (float)(0.8f + entity.level().getRandom().nextFloat() * 0.4f));
        }
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    public void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }
}

