/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.runes.miracle;

import com.google.common.collect.Multimap;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.item.curiosities.curios.runes.AbstractRuneCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;

public class RuneDexterityItem
extends AbstractRuneCurioItem {
    public RuneDexterityItem(Item.Properties builder) {
        super(builder, MalumSpiritTypes.AERIAL_SPIRIT);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("low_health_speed", new Object[0]));
    }

    @Override
    public void addAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> map, SlotContext slotContext, ItemStack stack) {
        this.addAttributeModifier(map, (Holder<Attribute>)Attributes.MOVEMENT_SPEED, this.getMovementSpeedBonus(slotContext.entity()));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        AttributeInstance attribute;
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity.level().getGameTime() % 5L == 0L && (attribute = livingEntity.getAttribute(Attributes.MOVEMENT_SPEED)) != null) {
            attribute.setDirty();
        }
    }

    public AttributeModifier getMovementSpeedBonus(LivingEntity entity) {
        float value = 0.2f;
        if (entity != null) {
            float health = entity.getHealth();
            float maxHealth = entity.getMaxHealth();
            value = 0.2f * (2.0f - health / maxHealth);
        }
        return new AttributeModifier(MalumMod.malumPath("rune_of_dexterity"), (double)value, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }
}

