/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.alchemical;

import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.CollectSpiritEvent;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import team.lodestar.lodestone.helpers.EntityHelper;

public class CurioAlchemicalRing
extends MalumCurioItem
implements IMalumEventResponder {
    public CurioAlchemicalRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.ALCHEMICAL);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("spirits_extend_effect", new Object[0]));
    }

    @Override
    public void spiritCollectionEvent(CollectSpiritEvent event, LivingEntity collector, double arcaneResonance) {
        for (MobEffectInstance instance : collector.getActiveEffectsMap().values()) {
            MobEffect e = (MobEffect)instance.getEffect().value();
            int durationChange = (int)(60.0 * arcaneResonance);
            if (e.isBeneficial()) {
                EntityHelper.extendEffect((MobEffectInstance)instance, (LivingEntity)collector, (int)durationChange, (int)3000);
                continue;
            }
            if (!e.getCategory().equals((Object)MobEffectCategory.HARMFUL)) continue;
            EntityHelper.shortenEffect((MobEffectInstance)instance, (LivingEntity)collector, (int)durationChange);
        }
    }
}

