/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.prospector;

import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.helpers.CurioHelper;

public class CurioHoarderRing
extends MalumCurioItem {
    public CurioHoarderRing(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.METALLIC);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("explosion_drops_collected", new Object[0]));
    }

    public static boolean hasHoarderRing(LivingEntity entity) {
        return entity != null && CurioHelper.hasCurioEquipped((LivingEntity)entity, (Item)((Item)MalumItems.RING_OF_THE_HOARDER.get()));
    }

    public static BlockPos getExplosionPos(boolean hasTheRing, BlockPos originalPos, LivingEntity entity, ItemStack droppedItem) {
        ItemStack itemInHand;
        if (hasTheRing && !(itemInHand = entity.getItemInHand(InteractionHand.OFF_HAND)).isEmpty() && !droppedItem.getItem().equals(itemInHand.getItem())) {
            return originalPos;
        }
        return hasTheRing ? entity.blockPosition().above() : originalPos;
    }
}

