/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.rotten;

import com.sammy.malum.common.effect.gluttony.GluttonyEffect;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.common.item.food.ConcentratedGluttonyItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.CollectSpiritEvent;
import com.sammy.malum.registry.common.MalumSoundEvents;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;

public class CurioStarvedBelt
extends MalumCurioItem
implements IMalumEventResponder {
    public CurioStarvedBelt(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.ROTTEN);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("spirits_gluttony", new Object[0]));
    }

    @Override
    public void spiritCollectionEvent(CollectSpiritEvent event, LivingEntity collector, double arcaneResonance) {
        Level level = collector.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            GluttonyEffect.applyGluttony(collector, b -> b.setInitialData(Mth.floor((double)(600.0 * arcaneResonance)), 0).setStackingData(0, 1).setLimitData(0, Mth.floor((double)(arcaneResonance * 5.0 - 1.0))));
            RandomSource random = serverLevel.random;
            SoundHelper.playSound((Entity)collector, (SoundEvent)((SoundEvent)MalumSoundEvents.HUNGRY_BELT_FEEDS.get()), (float)0.7f, (float)RandomHelper.randomBetween((RandomSource)random, (float)1.5f, (float)2.0f));
            SoundHelper.playSound((Entity)collector, (SoundEvent)SoundEvents.GENERIC_EAT, (float)0.7f, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.8f, (float)1.2f));
            ConcentratedGluttonyItem.createGluttonyVFX(serverLevel, collector, 0.5f);
        }
    }
}

