/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.curios.sets.soulward;

import com.google.common.collect.Multimap;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.SoulWardData;
import com.sammy.malum.common.item.IMalumEventResponder;
import com.sammy.malum.common.item.curiosities.curios.AbstractMalumCurioItem;
import com.sammy.malum.common.item.curiosities.curios.MalumCurioItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.events.ModifySoulWardPropertiesEvent;
import com.sammy.malum.core.systems.events.SoulWardDamageEvent;
import com.sammy.malum.registry.common.MalumAttributes;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import top.theillusivec4.curios.api.SlotContext;

public class CurioMagebaneBelt
extends MalumCurioItem
implements IMalumEventResponder {
    public CurioMagebaneBelt(Item.Properties builder) {
        super(builder, AbstractMalumCurioItem.MalumTrinketType.ORNATE);
    }

    @Override
    public void addExtraTooltipLines(Consumer<Component> consumer) {
        consumer.accept(ComponentHelper.positiveCurioEffect("soul_ward_magic_resilience", new Object[0]));
        consumer.accept(ComponentHelper.negativeCurioEffect("soul_ward_long_shatter_cooldown", new Object[0]));
    }

    @Override
    public void modifySoulWardPropertiesEvent(ModifySoulWardPropertiesEvent event, LivingEntity wardedEntity, ItemStack stack) {
        if (event.getSource().is(LodestoneDamageTypeTags.IS_MAGIC)) {
            event.setNewIntegrity(event.getOriginalIntegrity() * 1.5);
        }
    }

    @Override
    public void soulWardDamageEvent(SoulWardDamageEvent event, LivingEntity wardedEntity, ItemStack stack) {
        SoulWardData handler = event.getSoulWardHandler();
        if (handler.isDepleted()) {
            handler.addCooldown(wardedEntity, 8.0);
            return;
        }
        if (event.getSource().is(LodestoneDamageTypeTags.IS_MAGIC)) {
            handler.recoverSoulWard(wardedEntity, 1.5);
        }
    }

    @Override
    public void addAttributeModifiers(Multimap<Holder<Attribute>, AttributeModifier> map, SlotContext slotContext, ItemStack stack) {
        ResourceLocation id = MalumMod.malumPath("magebane_belt");
        this.addAttributeModifier(map, (Holder<Attribute>)MalumAttributes.SOUL_WARD_RECOVERY_RATE, new AttributeModifier(id, (double)0.4f, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        this.addAttributeModifier(map, (Holder<Attribute>)MalumAttributes.SOUL_WARD_CAPACITY, new AttributeModifier(id, 6.0, AttributeModifier.Operation.ADD_VALUE));
    }
}

