/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.curiosities.weapons.staff;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.StaffAbilityData;
import com.sammy.malum.common.data.attachment.soul_data.LivingSoulData;
import com.sammy.malum.common.entity.bolt.EntropicFlameBoltEntity;
import com.sammy.malum.common.entity.nitrate.EthericNitrateEntity;
import com.sammy.malum.common.item.curiosities.weapons.staff.AbstractStaffItem;
import com.sammy.malum.common.item.spirit.ISpiritAffiliatedItem;
import com.sammy.malum.core.helpers.ComponentHelper;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumParticles;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.visual_effects.networked.staff.UnwindingChaosChargeParticleEffect;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.registry.common.LodestoneAttributes;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.item.LodestoneItemProperties;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleDataBuilder;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;

public class UnwindingChaosStaffItem
extends AbstractStaffItem
implements ISpiritAffiliatedItem {
    public static final ColorParticleData AURIC_COLOR_DATA = EthericNitrateEntity.AURIC_COLOR_DATA;

    public UnwindingChaosStaffItem(Tier tier, float magicDamage, float chargeDuration, int chargeCapacity, LodestoneItemProperties properties) {
        super(tier, magicDamage, chargeDuration, chargeCapacity, properties);
    }

    public void modifyAttributeTooltipEvent(AddAttributeTooltipsEvent event) {
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect("unwinding_chaos_volley", new Object[0])});
        event.addTooltipLines(new Component[]{ComponentHelper.positiveEffect("unwinding_chaos_burn", new Object[0])});
    }

    @Override
    public MalumSpiritType getDefiningSpiritType() {
        MalumSpiritType[] spirits = new MalumSpiritType[]{MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT};
        return spirits[MalumMod.RANDOM.nextInt(spirits.length)];
    }

    public void outgoingDeathEvent(LivingDeathEvent event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        Level level = attacker.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!((LivingSoulData)target.getData(MalumAttachmentTypes.LIVING_SOUL_INFO)).shouldDropSpirits()) {
            return;
        }
        if (target.isOnFire()) {
            this.addStaffCharges(serverLevel, attacker, target, 160);
        }
    }

    public void finalizedOutgoingDamageEvent(LivingDamageEvent.Post event, LivingEntity attacker, LivingEntity target, ItemStack stack) {
        boolean canTriggerMagic;
        DamageSource source = event.getSource();
        Level level = attacker.level();
        RandomSource random = level.random;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (source.is(DamageTypeTags.IS_FIRE)) {
            this.addStaffCharges(serverLevel, attacker, target, 40);
        }
        if ((canTriggerMagic = source.is(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC)) || source.is(MalumDamageTypes.INVERTED_HEART_PROPAGATION)) {
            target.igniteForSeconds(5.0f);
        }
        if (canTriggerMagic) {
            for (int i = 0; i < 3; ++i) {
                MalumParticleEffectTypes.STAFF_SLAM.createEffect().originatesFrom((Entity)attacker).targets((Entity)target).randomOffset(random, 0.3f, 0.8f * (float)(random.nextBoolean() ? 1 : -1)).forwardOffset(1.4f).upwardOffset(0.3f).deviation(0.2f).randomDeviationAngle(random).color(stack.getItem()).spawn(serverLevel);
            }
            float pitch = RandomHelper.randomBetween((RandomSource)level.getRandom(), (float)0.75f, (float)2.0f);
            SoundHelper.playSound((Entity)attacker, (SoundEvent)((SoundEvent)MalumSoundEvents.WORLDSOUL_MOTIF_HEAVY_IMPACT.get()), (float)2.0f, (float)pitch);
        }
    }

    @Override
    public int getProjectileCount(Level level, LivingEntity livingEntity, float pct) {
        if (pct == 1.0f) {
            StaffAbilityData data = (StaffAbilityData)livingEntity.getData(MalumAttachmentTypes.STAFF_ABILITIES);
            return 3 + data.consumeAllStaffCharges(livingEntity) * 2;
        }
        return 0;
    }

    @Override
    public void fireProjectile(LivingEntity player, ItemStack stack, Level level, InteractionHand hand, int count) {
        int ceil = Mth.ceil((float)((float)count / 2.0f));
        int spawnDelay = 1 + ceil * 2;
        float spread = count > 0 ? (float)(ceil %= 7) * 0.1f * (float)((long)count % 2L == 0L ? 1 : -1) : 0.0f;
        float pitchOffset = count > 4 ? 2.0f + (2.0f - (float)ceil * 1.5f) : 0.5f;
        float velocity = 3.0f;
        float magicDamage = (float)player.getAttributes().getValue((Holder)LodestoneAttributes.MAGIC_DAMAGE);
        Vec3 pos = this.getProjectileSpawnPos(player, hand, 0.5f, 0.5f);
        EntropicFlameBoltEntity entity = new EntropicFlameBoltEntity(level, pos.x, pos.y, pos.z);
        entity.setData(player, magicDamage, spawnDelay);
        entity.setItem(stack);
        entity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), -pitchOffset, velocity, 0.0f);
        Vec3 projectileDirection = entity.getDeltaMovement();
        float yRot = (float)(Mth.atan2((double)projectileDirection.x, (double)projectileDirection.z) * 57.2957763671875);
        float yaw = (float)Math.toRadians(yRot);
        Vec3 left = new Vec3(-Math.cos(yaw), 0.0, Math.sin(yaw));
        entity.setDeltaMovement(entity.getDeltaMovement().add(left.scale((double)spread)));
        level.addFreshEntity((Entity)entity);
    }

    public void addStaffCharges(ServerLevel serverLevel, LivingEntity attacker, LivingEntity target, int charge) {
        ((StaffAbilityData)attacker.getData(MalumAttachmentTypes.STAFF_ABILITIES)).reduceStaffChargeCooldown(attacker, charge);
        float pitch = RandomHelper.randomBetween((RandomSource)attacker.getRandom(), (float)0.75f, (float)1.25f);
        SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)MalumSoundEvents.WORLDSOUL_MOTIF_LIGHT_IMPACT.get()), (SoundSource)attacker.getSoundSource(), (float)1.5f, (float)pitch);
        MalumParticleEffectTypes.UNWINDING_CHAOS_CHARGE.createEffect((Entity)target).color(this.getDefiningSpiritType()).customData(new UnwindingChaosChargeParticleEffect.UnwindingChaosChargeEffectData(attacker.getId())).spawn(serverLevel);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnChargeParticles(Level pLevel, LivingEntity pLivingEntity, Vec3 pos, ItemStack pStack, float pct) {
        RandomSource random = pLevel.random;
        WorldParticleBuilder builder = WorldParticleBuilder.create(MalumParticles.CHAOS_TARGET).setTransparencyData(GenericParticleData.create((float)(0.7f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN).build()).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional((Vec3)pLivingEntity.getLookAngle().normalize())).setScaleData(GenericParticleData.create((float)(0.3f * pct), (float)0.0f).setEasing(Easing.SINE_IN_OUT).build()).setMotion(pLivingEntity.getLookAngle().normalize().scale((double)(0.2f * pct))).setRenderTarget(RenderHandler.LATE_DELAYED_RENDER).enableForcedSpawn().setLifetime(4).enableNoClip();
        for (int i = 0; i < 2; ++i) {
            SpinParticleDataBuilder spin = SpinParticleData.create((float)0.05f, (float)0.1f);
            long delta = (long)(i == 1 ? 1 : -1) * (pLevel.getGameTime() + (long)(i * 5));
            float offset = 0.4f * Mth.sin((float)((float)delta / 8.0f % 6.28f));
            MalumSpiritType spirit = i == 0 ? MalumSpiritTypes.AQUEOUS_SPIRIT : MalumSpiritTypes.INFERNAL_SPIRIT;
            builder.setColorData(spirit.createColorData().build()).setLifeDelay(i == 0 ? 2 : 4).setSpinData(spin.setSpinOffset((float)i * 1.57f + offset).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.ADDITIVE).spawn(pLevel, pos.x, pos.y, pos.z).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT).spawn(pLevel, pos.x, pos.y, pos.z);
        }
    }
}

