/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.item.food;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class BottledDrinkItem
extends Item {
    public BottledDrinkItem(Item.Properties builder) {
        super(builder.craftRemainder(Items.GLASS_BOTTLE));
    }

    public ItemStack finishUsingItem(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving) {
        super.finishUsingItem(pStack, pLevel, pEntityLiving);
        if (pEntityLiving instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)pEntityLiving;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverplayer, pStack);
            serverplayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (pStack.isEmpty()) {
            return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
        }
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            if (!((Player)pEntityLiving).getAbilities().instabuild) {
                ItemStack itemstack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                if (!player.getInventory().add(itemstack)) {
                    player.drop(itemstack, false);
                }
            }
        }
        return pStack;
    }

    public int getUseDuration(ItemStack pStack, LivingEntity livingEntity) {
        return 60;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.DRINK;
    }

    public SoundEvent getDrinkingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    public SoundEvent getEatingSound() {
        return SoundEvents.HONEY_DRINK;
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pHand) {
        return ItemUtils.startUsingInstantly((Level)pLevel, (Player)pPlayer, (InteractionHand)pHand);
    }
}

