/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.particle.base.spirit;

import com.sammy.malum.common.packets.particle.base.BlockBasedParticleEffectPacket;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class SpiritBasedBlockParticleEffectPacket
extends BlockBasedParticleEffectPacket {
    protected final List<String> spirits;

    public SpiritBasedBlockParticleEffectPacket(List<String> spirits, BlockPos pos) {
        super(pos);
        this.spirits = spirits;
    }

    public SpiritBasedBlockParticleEffectPacket(FriendlyByteBuf buf) {
        super(buf);
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.readUtf());
        }
        this.spirits = spirits;
    }

    @Override
    public void serialize(FriendlyByteBuf buf) {
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.writeUtf(string);
        }
        super.serialize(buf);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(IPayloadContext iPayloadContext) {
        for (String string : this.spirits) {
            this.handle(iPayloadContext, MalumSpiritType.getSpiritType(string));
        }
    }

    protected abstract void handle(IPayloadContext var1, MalumSpiritType var2);
}

