/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.packets.spirit_diode;

import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import team.lodestar.lodestone.systems.network.OneSidedPayloadData;

public class SpiritDiodeVisualUpdatePayload
extends OneSidedPayloadData {
    private final BlockPos pos;
    private final int outputSignal;
    private final int inputSignal;
    private final boolean isPowering;

    public SpiritDiodeVisualUpdatePayload(BlockPos pos, int outputSignal, int inputSignal, boolean isPowering) {
        this.pos = pos;
        this.outputSignal = outputSignal;
        this.inputSignal = inputSignal;
        this.isPowering = isPowering;
    }

    public SpiritDiodeVisualUpdatePayload(FriendlyByteBuf buf) {
        this.pos = (BlockPos)BlockPos.STREAM_CODEC.decode((Object)buf);
        this.outputSignal = buf.readInt();
        this.inputSignal = buf.readInt();
        this.isPowering = buf.readBoolean();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handle(IPayloadContext iPayloadContext) {
        Level level = iPayloadContext.player().level();
        BlockEntity blockEntity = level.getBlockEntity(this.pos);
        if (blockEntity instanceof SpiritDiodeBlockEntity) {
            SpiritDiodeBlockEntity spiritDiode = (SpiritDiodeBlockEntity)blockEntity;
            spiritDiode.updateVisuals(this.outputSignal, this.inputSignal, this.isPowering);
        }
    }

    public void serialize(FriendlyByteBuf friendlyByteBuf) {
        BlockPos.STREAM_CODEC.encode((Object)friendlyByteBuf, (Object)this.pos);
        friendlyByteBuf.writeInt(this.outputSignal);
        friendlyByteBuf.writeInt(this.inputSignal);
        friendlyByteBuf.writeBoolean(this.isPowering);
    }
}

