/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.core.systems.recipe.SpiritBasedRecipeInput;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.registry.common.recipe.MalumRecipeSerializers;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import team.lodestar.lodestone.systems.recipe.LodestoneInWorldRecipe;

public class SpiritRepairRecipe
extends LodestoneInWorldRecipe<SpiritBasedRecipeInput> {
    public static final MapCodec<SpiritRepairRecipe> CODEC = RecordCodecBuilder.mapCodec(obj -> obj.group((App)Codec.FLOAT.optionalFieldOf("durabilityPercentage", (Object)Float.valueOf(0.5f)).forGetter(recipe -> Float.valueOf(recipe.durabilityPercentage)), (App)Codec.STRING.optionalFieldOf("itemIdRegex", (Object)"").forGetter(recipe -> recipe.itemIdRegex), (App)Codec.STRING.optionalFieldOf("modIdRegex", (Object)"").forGetter(recipe -> recipe.modIdRegex), (App)ResourceLocation.CODEC.listOf().optionalFieldOf("inputs", List.of()).forGetter(recipe -> recipe.itemsForRepair.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getKey(arg_0)).collect(Collectors.toList())), (App)SizedIngredient.FLAT_CODEC.fieldOf("repairMaterial").forGetter(recipe -> recipe.repairMaterial), (App)SpiritIngredient.CODEC.codec().listOf().fieldOf("spirits").forGetter(recipe -> recipe.spirits), (App)BuiltInRegistries.ITEM.byNameCodec().optionalFieldOf("repairOutputOverride", (Object)Items.AIR).forGetter(recipe -> recipe.repairResult)).apply((Applicative)obj, SpiritRepairRecipe::new));
    public static final String NAME = "spirit_repair";
    public final float durabilityPercentage;
    public final String itemIdRegex;
    public final String modIdRegex;
    public final ArrayList<Item> itemsForRepair;
    public final List<SpiritIngredient> spirits;
    public final SizedIngredient repairMaterial;
    public final Item repairResult;

    public SpiritRepairRecipe(float durabilityPercentage, String itemIdRegex, String modIdRegex, List<ResourceLocation> itemsForRepair, SizedIngredient repairMaterial, List<SpiritIngredient> spirits, Item repairResult) {
        super((RecipeSerializer)MalumRecipeSerializers.REPAIR_RECIPE_SERIALIZER.get(), (RecipeType)MalumRecipeTypes.SPIRIT_REPAIR.get());
        this.durabilityPercentage = durabilityPercentage;
        this.itemIdRegex = itemIdRegex;
        this.modIdRegex = modIdRegex;
        this.repairMaterial = repairMaterial;
        this.itemsForRepair = itemsForRepair.stream().map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).get(arg_0)).collect(Collectors.toCollection(ArrayList::new));
        this.spirits = spirits;
        this.repairResult = repairResult;
        if (repairResult.equals(Items.AIR)) {
            SpiritRepairRecipe.addToInputs(this.itemsForRepair, itemIdRegex, modIdRegex);
        }
    }

    public boolean isValidItemForRepair(ItemStack input) {
        return this.itemsForRepair.stream().anyMatch(i -> i.equals(input.getItem()));
    }

    public ItemStack getResultItem(ItemStack input) {
        if (!this.repairResult.equals(Items.AIR)) {
            ItemStack output = this.repairResult.getDefaultInstance();
            output.applyComponents(input.getComponents());
            return output;
        }
        ItemStack output = input.copy();
        output.setDamageValue(Math.max(0, input.getDamageValue() - (int)((float)output.getMaxDamage() * this.durabilityPercentage)));
        return output;
    }

    public boolean matches(SpiritBasedRecipeInput input, Level level) {
        return input.test(this.repairMaterial, this.spirits);
    }

    public boolean matches(SpiritBasedRecipeInput input, ItemStack repairTarget) {
        return input.test(this.repairMaterial, this.spirits) && this.itemsForRepair.stream().anyMatch(i -> i.equals(repairTarget.getItem()));
    }

    public final ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.repairMaterial.getItems()[0];
    }

    protected static void addToInputs(ArrayList<Item> inputs, String itemIdRegex, String modIdRegex) {
        for (int i = 0; i < BuiltInRegistries.ITEM.size(); ++i) {
            ResourceLocation id;
            Item item = (Item)BuiltInRegistries.ITEM.byId(i);
            if (!item.isRepairable(item.getDefaultInstance()) || !(id = BuiltInRegistries.ITEM.getKey((Object)item)).getPath().matches(itemIdRegex)) continue;
            if (!modIdRegex.isEmpty() && !id.getNamespace().matches(modIdRegex)) break;
            if (inputs.contains(item)) continue;
            inputs.add(item);
        }
    }
}

