/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.sammy.malum.registry.common.recipe.MalumRecipeSerializers;
import com.sammy.malum.registry.common.recipe.MalumRecipeTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.recipe.LodestoneInWorldRecipe;

public class SpiritTransmutationRecipe
extends LodestoneInWorldRecipe<SingleRecipeInput> {
    public static final MapCodec<SpiritTransmutationRecipe> CODEC = RecordCodecBuilder.mapCodec(obj -> obj.group((App)Ingredient.CODEC.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)ItemStack.CODEC.fieldOf("output").forGetter(recipe -> recipe.output), (App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group)).apply((Applicative)obj, SpiritTransmutationRecipe::new));
    public static final String NAME = "spirit_transmutation";
    public final Ingredient ingredient;
    public final ItemStack output;
    public final String group;

    public SpiritTransmutationRecipe(Ingredient ingredient, ItemStack output, String group) {
        super((RecipeSerializer)MalumRecipeSerializers.SPIRIT_TRANSMUTATION_RECIPE_SERIALIZER.get(), (RecipeType)MalumRecipeTypes.SPIRIT_TRANSMUTATION.get(), output);
        this.ingredient = ingredient;
        this.output = output;
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient.test(input.item());
    }
}

