/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.eldritch;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class EldritchEarthenRiteType
extends TotemicRiteType {
    public EldritchEarthenRiteType() {
        super("greater_earthen_rite", MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT, MalumSpiritTypes.EARTHEN_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.DIRECTIONAL_BLOCK_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getBlocksAhead(totemBase).forEach(p -> {
                    boolean canBreak;
                    BlockState state = level.getBlockState(p);
                    boolean bl = canBreak = !state.isAir() && state.getDestroySpeed((BlockGetter)level, p) != -1.0f;
                    if (canBreak) {
                        level.destroyBlock(p, true);
                        MalumParticleEffectTypes.BLOCK_RITE_EFFECT.createEffect((BlockPos)p).color(MalumSpiritTypes.EARTHEN_SPIRIT).spawn(level);
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.DIRECTIONAL_BLOCK_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getBlocksAhead(totemBase).forEach(p -> {
                    boolean canPlace;
                    BlockState state = level.getBlockState(p);
                    boolean bl = canPlace = state.isAir() || state.canBeReplaced();
                    if (canPlace) {
                        BlockState cobblestone = Blocks.COBBLESTONE.defaultBlockState();
                        level.setBlockAndUpdate(p, cobblestone);
                        level.levelEvent(2001, p, Block.getId((BlockState)cobblestone));
                        MalumParticleEffectTypes.BLOCK_RITE_EFFECT.createEffect((BlockPos)p).color(MalumSpiritTypes.EARTHEN_SPIRIT).spawn(level);
                    }
                });
            }
        };
    }
}

