/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.eldritch;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EldritchInfernalRiteType
extends TotemicRiteType {
    public EldritchInfernalRiteType() {
        super("greater_infernal_rite", MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.DIRECTIONAL_BLOCK_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getBlocksAhead(totemBase).forEach(p -> {
                    SmeltingRecipe recipe;
                    ItemStack output;
                    Item patt0$temp;
                    BlockState state = level.getBlockState(p);
                    Optional recipeOptional = level.getRecipeManager().getRecipeFor(RecipeType.SMELTING, (RecipeInput)new SingleRecipeInput(new ItemStack((ItemLike)state.getBlock().asItem(), 1)), (Level)level);
                    if (recipeOptional.isPresent() && (patt0$temp = (output = (recipe = (SmeltingRecipe)((RecipeHolder)recipeOptional.get()).value()).getResultItem((HolderLookup.Provider)level.registryAccess())).getItem()) instanceof BlockItem) {
                        BlockItem blockItem = (BlockItem)patt0$temp;
                        Block block = blockItem.getBlock();
                        BlockState newState = block.defaultBlockState();
                        level.setBlockAndUpdate(p, newState);
                        level.levelEvent(2001, p, Block.getId((BlockState)newState));
                        MalumParticleEffectTypes.BLOCK_RITE_EFFECT.createEffect((BlockPos)p).color(MalumSpiritTypes.INFERNAL_SPIRIT).spawn(level);
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.RADIAL_BLOCK_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyBlocks(totemBase, AbstractFurnaceBlock.class).forEach(p -> {
                    BlockEntity patt0$temp = level.getBlockEntity(p);
                    if (patt0$temp instanceof AbstractFurnaceBlockEntity) {
                        AbstractFurnaceBlockEntity furnace = (AbstractFurnaceBlockEntity)patt0$temp;
                        MalumParticleEffectTypes.BLOCK_RITE_EFFECT.createEffect((BlockPos)p).color(MalumSpiritTypes.INFERNAL_SPIRIT).spawn(level);
                        furnace.cookingProgress = Math.min(furnace.cookingProgress + 20, furnace.cookingTotalTime - 1);
                    }
                });
            }
        };
    }
}

