/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.spiritrite.eldritch;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.core.systems.rite.TotemicRiteEffect;
import com.sammy.malum.core.systems.rite.TotemicRiteType;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;

public class EldritchSacredRiteType
extends TotemicRiteType {
    public EldritchSacredRiteType() {
        super("greater_sacred_rite", MalumSpiritTypes.ELDRITCH_SPIRIT, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT);
    }

    @Override
    public TotemicRiteEffect getNaturalRiteEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.RADIAL_BLOCK_EFFECT){

            @Override
            public int getRiteEffectHorizontalRadius() {
                return 4;
            }

            @Override
            public int getRiteEffectVerticalRadius() {
                return 2;
            }

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                this.getNearbyBlocks(totemBase, BonemealableBlock.class).forEach(p -> {
                    if (level.random.nextFloat() <= 0.06f) {
                        BonemealableBlock bonemealableBlock;
                        BlockState state = level.getBlockState(p);
                        Block block = state.getBlock();
                        if (block instanceof CropBlock) {
                            for (int i = 0; i < 5 + level.random.nextInt(3); ++i) {
                                state.randomTick(level, p, level.random);
                            }
                        } else if (block instanceof BonemealableBlock && (bonemealableBlock = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)level, p, state) && bonemealableBlock.isBonemealSuccess((Level)level, level.random, p, state)) {
                            bonemealableBlock.performBonemeal(level, level.random, p, state);
                        }
                        BlockPos particlePos = state.canOcclude() ? p : p.below();
                        MalumParticleEffectTypes.BLOCK_GROW_RITE_EFFECT.createEffect(particlePos).color(MalumSpiritTypes.SACRED_SPIRIT).spawn(level);
                    }
                });
            }
        };
    }

    @Override
    public TotemicRiteEffect getCorruptedEffect() {
        return new TotemicRiteEffect(this, TotemicRiteEffect.MalumRiteEffectCategory.LIVING_ENTITY_EFFECT){

            @Override
            public void doRiteEffect(TotemBaseBlockEntity totemBase, ServerLevel level) {
                Map<Class, List<Animal>> animalMap = this.getNearbyEntities(totemBase, Animal.class).collect(Collectors.groupingBy(Object::getClass));
                for (List<Animal> animals : animalMap.values()) {
                    if (animals.size() > 20) continue;
                    animals.forEach(e -> {
                        if (e.canFallInLove() && e.getAge() == 0 && level.random.nextFloat() <= 0.2f) {
                            e.setInLoveTime(600);
                            MalumParticleEffectTypes.ENTITY_RITE_EFFECT.createEffect((Entity)e).color(MalumSpiritTypes.SACRED_SPIRIT).spawn(level);
                        }
                    });
                }
            }
        };
    }
}

