/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldevent;

import com.mojang.serialization.DynamicOps;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumWorldEventTypes;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.MalumNetworkedWeaponParticleEffectType;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.DamageTypeHelper;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.SoundHelper;
import team.lodestar.lodestone.systems.network.WeaponParticleEffectType;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectColorData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectExtraData;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectType;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class DelayedDamageWorldEvent
extends WorldEventInstance {
    protected ResourceKey<DamageType> physicalDamageType = DamageTypes.PLAYER_ATTACK;
    protected ResourceKey<DamageType> magicDamageType = MalumDamageTypes.VOODOO;
    protected UUID attackerUUID;
    protected UUID projectileUUID;
    protected UUID targetUUID;
    protected int delay;
    protected float physicalDamage;
    protected float magicDamage;
    protected Holder<SoundEvent> soundEvent;
    protected float minPitch;
    protected float maxPitch;
    protected float minVolume;
    protected float maxVolume;
    protected NetworkedParticleEffectType particleEffect;
    protected MalumNetworkedParticleEffectColorData particleColor;
    protected NetworkedParticleEffectExtraData nbtData;

    public DelayedDamageWorldEvent(Entity target) {
        this();
        this.targetUUID = target.getUUID();
    }

    public DelayedDamageWorldEvent() {
        this((WorldEventType)MalumWorldEventTypes.DELAYED_DAMAGE.get());
    }

    public DelayedDamageWorldEvent(WorldEventType type) {
        super(type);
    }

    public DelayedDamageWorldEvent setAttacker(Entity attacker) {
        return this.setAttacker(attacker, attacker);
    }

    public DelayedDamageWorldEvent setAttacker(@Nonnull Entity attacker, Entity projectile) {
        this.attackerUUID = attacker.getUUID();
        this.projectileUUID = projectile != null ? projectile.getUUID() : null;
        return this;
    }

    public DelayedDamageWorldEvent setDamageData(float physicalDamage, float magicDamage, int delay) {
        this.physicalDamage = physicalDamage;
        this.magicDamage = magicDamage;
        this.delay = delay;
        return this;
    }

    public DelayedDamageWorldEvent setDamageData(ResourceKey<DamageType> physicalDamageType, float physicalDamage, ResourceKey<DamageType> magicDamageType, float magicDamage, int delay) {
        this.physicalDamage = physicalDamage;
        this.magicDamage = magicDamage;
        this.delay = delay;
        return this.setPhysicalDamageType(physicalDamageType).setMagicDamageType(magicDamageType);
    }

    public DelayedDamageWorldEvent setPhysicalDamageType(ResourceKey<DamageType> physicalDamageType) {
        this.physicalDamageType = physicalDamageType;
        return this;
    }

    public DelayedDamageWorldEvent setMagicDamageType(ResourceKey<DamageType> magicDamageType) {
        this.magicDamageType = magicDamageType;
        return this;
    }

    public DelayedDamageWorldEvent setSound(Holder<SoundEvent> soundEvent, float minPitch, float maxPitch, float volume) {
        return this.setSound(soundEvent, minPitch, maxPitch, volume, volume);
    }

    public DelayedDamageWorldEvent setSound(Holder<SoundEvent> soundEvent, float minPitch, float maxPitch, float minVolume, float maxVolume) {
        this.soundEvent = soundEvent;
        this.minPitch = minPitch;
        this.maxPitch = maxPitch;
        this.minVolume = minVolume;
        this.maxVolume = maxVolume;
        return this;
    }

    public DelayedDamageWorldEvent setImpactParticleEffect(NetworkedParticleEffectType particleEffect, MalumNetworkedParticleEffectColorData color) {
        this.particleEffect = particleEffect;
        this.particleColor = color;
        return this;
    }

    public DelayedDamageWorldEvent setParticleEffectNBT(NetworkedParticleEffectExtraData nbtData) {
        this.nbtData = nbtData;
        return this;
    }

    public void tick(Level level) {
        if (this.delay > 0) {
            --this.delay;
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Entity target = serverLevel.getEntity(this.targetUUID);
            Entity attacker = serverLevel.getEntity(this.attackerUUID);
            Entity projectile = serverLevel.getEntity(this.projectileUUID);
            if (target != null && target.isAlive()) {
                Vec3 deltaMovement = target.getDeltaMovement();
                if (this.physicalDamage > 0.0f) {
                    target.invulnerableTime = 0;
                    target.hurt(DamageTypeHelper.create((Level)level, this.physicalDamageType, (Entity)projectile, (Entity)attacker), this.physicalDamage);
                }
                if (this.magicDamage > 0.0f) {
                    target.invulnerableTime = 0;
                    target.hurt(DamageTypeHelper.create((Level)level, this.magicDamageType, (Entity)projectile, (Entity)attacker), this.magicDamage);
                }
                target.setDeltaMovement(deltaMovement);
                if (this.soundEvent != null) {
                    float pitch = RandomHelper.randomBetween((RandomSource)serverLevel.getRandom(), (float)this.minPitch, (float)this.maxPitch);
                    float volume = RandomHelper.randomBetween((RandomSource)serverLevel.getRandom(), (float)this.minVolume, (float)this.maxVolume);
                    SoundHelper.playSound((Entity)target, (SoundEvent)((SoundEvent)this.soundEvent.value()), (float)volume, (float)pitch);
                }
                if (this.particleEffect != null) {
                    NetworkedParticleEffectType networkedParticleEffectType = this.particleEffect;
                    if (networkedParticleEffectType instanceof MalumNetworkedWeaponParticleEffectType) {
                        MalumNetworkedWeaponParticleEffectType weaponParticleEffect = (MalumNetworkedWeaponParticleEffectType)networkedParticleEffectType;
                        weaponParticleEffect.createEffect().originatesFrom(attacker).targets(target).tiedToTarget().color(this.particleColor).customData((WeaponParticleEffectType.WeaponParticleEffectData)this.nbtData).spawn(serverLevel);
                    } else {
                        this.particleEffect.createEffect(target).color((NetworkedParticleEffectColorData)this.particleColor).customData(this.nbtData).spawn(serverLevel);
                    }
                }
            }
        }
        this.end(level);
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        if (this.physicalDamageType != DamageTypes.PLAYER_ATTACK) {
            compoundTag.putString("physicalDamageType", this.physicalDamageType.location().toString());
        }
        if (this.magicDamageType != MalumDamageTypes.VOODOO) {
            compoundTag.putString("magicDamageType", this.magicDamageType.location().toString());
        }
        if (this.attackerUUID != null) {
            compoundTag.putUUID("attackerUUID", this.attackerUUID);
        }
        compoundTag.putUUID("targetUUID", this.targetUUID);
        compoundTag.putFloat("physicalDamage", this.physicalDamage);
        compoundTag.putFloat("magicDamage", this.magicDamage);
        compoundTag.putInt("delay", this.delay);
        if (this.soundEvent != null) {
            compoundTag.put("soundEvent", (Tag)SoundEvent.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, this.soundEvent).result().orElseThrow());
            compoundTag.putFloat("minPitch", this.minPitch);
            compoundTag.putFloat("maxPitch", this.maxPitch);
            compoundTag.putFloat("minVolume", this.minVolume);
            compoundTag.putFloat("maxVolume", this.maxVolume);
        }
        if (this.particleEffect != null) {
            compoundTag.put("particleEffect", (Tag)NetworkedParticleEffectType.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.particleEffect).result().orElseThrow());
            compoundTag.put("particleColor", (Tag)MalumNetworkedParticleEffectColorData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.particleColor).result().orElseThrow());
        }
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        this.physicalDamageType = compoundTag.contains("physicalDamageType") ? ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)compoundTag.getString("physicalDamageType"))) : DamageTypes.PLAYER_ATTACK;
        this.magicDamageType = compoundTag.contains("magicDamageType") ? ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)ResourceLocation.parse((String)compoundTag.getString("magicDamageType"))) : MalumDamageTypes.VOODOO;
        this.attackerUUID = compoundTag.getUUID("attackerUUID");
        this.targetUUID = compoundTag.getUUID("targetUUID");
        this.physicalDamage = compoundTag.getFloat("physicalDamage");
        this.magicDamage = compoundTag.getFloat("magicDamage");
        this.delay = compoundTag.getInt("delay");
        this.soundEvent = SoundEvent.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get("soundEvent")).result().orElse(null);
        this.minPitch = compoundTag.getFloat("minPitch");
        this.maxPitch = compoundTag.getFloat("maxPitch");
        this.minVolume = compoundTag.getFloat("minVolume");
        this.maxVolume = compoundTag.getFloat("maxVolume");
        this.particleEffect = NetworkedParticleEffectType.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get("particleEffect")).result().orElse(null);
        this.particleColor = MalumNetworkedParticleEffectColorData.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compoundTag.get("particleColor")).result().orElse(null);
    }
}

