/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.worldgen.blight;

import com.google.common.collect.ImmutableList;
import com.sammy.malum.common.worldgen.blight.ScarstoneFeature;
import com.sammy.malum.registry.common.MalumParticleEffectTypes;
import com.sammy.malum.registry.common.MalumSoundEvents;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import com.sammy.malum.registry.common.MalumTags;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.visual_effects.networked.blight.BlightParticleEffect;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.block.BlockStateHelper;
import team.lodestar.lodestone.systems.easing.Easing;

public class BlightFeature
extends Feature<NoneFeatureConfiguration> {
    private static final PerlinSimplexNoise COVERING_NOISE = new PerlinSimplexNoise((RandomSource)new WorldgenRandom((RandomSource)new LegacyRandomSource(1234L)), (List)ImmutableList.of((Object)0));

    public BlightFeature() {
        super(NoneFeatureConfiguration.CODEC);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        BlightFeature.generateBlight(level, pos, 8).place(level);
        return true;
    }

    public static void createBlightVFX(ServerLevel level, BlockPos sourcePos, LodestoneWorldgenBuilder blight) {
        MalumParticleEffectTypes.BLIGHT_PROPAGATION.createEffect(sourcePos).customData(new BlightParticleEffect.BlightEffectData(blight.getAffectedArea(0))).spawn(level);
        MalumParticleEffectTypes.BLIGHT_PLANT_GROWTH.createEffect(sourcePos).customData(new BlightParticleEffect.BlightEffectData(blight.getAffectedArea(1))).spawn(level);
    }

    public static void createScarstoneVFX(ServerLevel level, BlockPos sourcePos, LodestoneWorldgenBuilder scarstone) {
        MalumParticleEffectTypes.SCARSTONE_FORMS.createEffect(sourcePos).color(MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.AQUEOUS_SPIRIT).customData(new BlightParticleEffect.BlightEffectData(scarstone.getAffectedArea(0))).spawn(level);
        MalumParticleEffectTypes.STRANGE_CRYSTAL_FORMS.createEffect(sourcePos).color(MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.INFERNAL_SPIRIT).customData(new BlightParticleEffect.BlightEffectData(scarstone.getAffectedArea(1))).spawn(level);
    }

    public static LodestoneWorldgenBuilder generateBlight(WorldGenLevel level, BlockPos pos, boolean allowScarstone, int radius) {
        RandomSource random = level.getRandom();
        LodestoneWorldgenBuilder builder = LodestoneWorldgenBuilder.create();
        if (allowScarstone && random.nextFloat() < 0.1f) {
            int offset = (int)((float)radius * 0.8f);
            int xOffset = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CIRC_OUT, (int)(offset / 2), (int)(offset * 2)) * (random.nextBoolean() ? 1 : -1);
            int zOffset = RandomHelper.randomBetween((RandomSource)random, (Easing)Easing.CIRC_OUT, (int)(offset / 2), (int)(offset * 2)) * (random.nextBoolean() ? 1 : -1);
            BlockPos scarstonePos = pos.offset(xOffset, 0, zOffset);
            LodestoneWorldgenBuilder extraBlight = BlightFeature.generateBlight(level, scarstonePos, radius);
            LodestoneWorldgenBuilder scarstone = ScarstoneFeature.generateScarstone(level, scarstonePos, (int)((float)radius * 0.7f));
            builder.merge(extraBlight).merge(scarstone);
            if (level instanceof ServerLevel) {
                ServerLevel realLevel = (ServerLevel)level;
                BlightFeature.createBlightVFX(realLevel, pos, extraBlight);
                BlightFeature.createScarstoneVFX(realLevel, scarstonePos, scarstone);
                level.playSound(null, scarstonePos, (SoundEvent)MalumSoundEvents.SCARSTONE_PROPAGATION.get(), SoundSource.BLOCKS, 2.0f, 1.0f);
            }
        }
        LodestoneWorldgenBuilder blight = BlightFeature.generateBlight(level, pos, radius);
        builder.merge(blight);
        if (level instanceof ServerLevel) {
            ServerLevel realLevel = (ServerLevel)level;
            BlightFeature.createBlightVFX(realLevel, pos, blight);
            level.playSound(null, pos, (SoundEvent)MalumSoundEvents.BLIGHT_PROPAGATION.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return builder;
    }

    private static LodestoneWorldgenBuilder generateBlight(WorldGenLevel level, BlockPos pos, int radius) {
        List<BlockPos> coveringArea;
        RandomSource random = level.getRandom();
        LodestoneWorldgenBuilder builder = LodestoneWorldgenBuilder.create().addAdditionalPlacement(BlightFeature::cleanupFoliage);
        LodestoneWorldgenBuilderLayer blightLayer = builder.createLayer();
        LodestoneWorldgenBuilderLayer floraLayer = builder.createLayer();
        LodestoneWorldgenBuilderLayer coveringLayer = builder.createLayer();
        List<BlockPos> blightedArea = BlightFeature.fetchCoveringPositions((ServerLevelAccessor)level, pos, radius);
        for (BlockPos blockPos : blightedArea) {
            BlockState state = level.getBlockState(blockPos);
            if (!state.is(MalumTags.BlockTags.BLIGHT_REPLACEABLE)) continue;
            blightLayer.add(blockPos, (Block)MalumBlocks.BLIGHTED_EARTH.get());
        }
        ArrayList<BlockPos> floraPositions = new ArrayList<BlockPos>(blightedArea);
        if (!floraPositions.isEmpty()) {
            Collections.shuffle(floraPositions);
            int floraCount = Math.min(random.nextInt(1, radius * 4 + 1), floraPositions.size() - 1);
            boolean hasSoulwood = false;
            for (BlockPos blockPos : floraPositions) {
                Block block;
                BlockPos above = blockPos.above();
                BlockState state = level.getBlockState(above);
                if (!state.getFluidState().isEmpty() || !state.canBeReplaced() || state.is(MalumTags.BlockTags.BLIGHTED_PLANTS)) continue;
                if (radius > 3 && !hasSoulwood && random.nextFloat() < 0.1f) {
                    block = (Block)MalumBlocks.SOULWOOD_SAPLING.get();
                    hasSoulwood = true;
                } else {
                    block = random.nextFloat() < 0.4f ? (random.nextFloat() < 0.2f ? (Block)MalumBlocks.BLIGHTPEARL.get() : (Block)MalumBlocks.BLIGHTROOT.get()) : (Block)MalumBlocks.BLIGHTED_GROWTH.get();
                }
                floraLayer.add(above, block);
                if (--floraCount != 0) continue;
                break;
            }
        }
        if (!(coveringArea = BlightFeature.fetchCoveringPositions((ServerLevelAccessor)level, pos, radius + 3)).isEmpty()) {
            Collections.shuffle(coveringArea);
            int coveringCount = Math.min(random.nextInt(1, 8 + radius * 8 + 1), coveringArea.size() - 1);
            for (BlockPos blockPos : coveringArea) {
                BlockState state = level.getBlockState(blockPos);
                if (!state.is(MalumTags.BlockTags.BLIGHT_REPLACEABLE) || blightLayer.containsKey(blockPos)) continue;
                BlockPos above = blockPos.above();
                boolean isWaterLogged = level.getBlockState(above).getFluidState().is((Fluid)Fluids.WATER);
                BlockState covering = (BlockState)((BlockState)((Block)MalumBlocks.BLIGHT.get()).defaultBlockState().setValue((Property)MultifaceBlock.getFaceProperty((Direction)Direction.DOWN), (Comparable)Boolean.valueOf(true))).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(isWaterLogged));
                coveringLayer.add(above, covering);
                if (--coveringCount != 0) continue;
                break;
            }
        }
        return builder;
    }

    public static void cleanupFoliage(WorldGenLevel level, LodestoneWorldgenBuilderEntry entry) {
        BlockPos.MutableBlockPos mutable = entry.position().mutable();
        for (int i = 0; i < 3; ++i) {
            mutable.move(Direction.UP);
            BlockState aboveState = level.getBlockState((BlockPos)mutable);
            if (!aboveState.getFluidState().isEmpty() || !aboveState.is(MalumTags.BlockTags.BLIGHT_REMOVABLE)) continue;
            level.setBlock((BlockPos)mutable, Blocks.AIR.defaultBlockState(), 19);
            if (!(level instanceof Level)) continue;
            Level realLevel = (Level)level;
            BlockStateHelper.updateState((Level)realLevel, (BlockPos)mutable);
        }
    }

    public static List<BlockPos> fetchCoveringPositions(ServerLevelAccessor level, BlockPos center, int radius) {
        return BlightFeature.fetchCoveringPositions(level, center, radius, BlightFeature::canBeRemoved).stream().filter(p -> {
            BlockState above = level.getBlockState(p.above());
            return above.canBeReplaced() || above.is(MalumTags.BlockTags.BLIGHT_REMOVABLE);
        }).collect(Collectors.toList());
    }

    public static List<BlockPos> fetchCoveringPositions(ServerLevelAccessor level, BlockPos center, int radius, Predicate<BlockState> statePredicate) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int x = center.getX();
        int z = center.getZ();
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        int verticalRange = 6;
        float limit = Mth.sqrt((float)(radius * radius + radius * radius));
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                int k;
                double theta;
                double noise;
                double threshold;
                int offsetX = x + i;
                int offsetZ = z + j;
                float distance = Mth.sqrt((float)(i * i + j * j));
                if (!((double)distance <= (threshold = (double)(Easing.SINE_IN_OUT.clamped(noise = (COVERING_NOISE.getValue((double)(x * 10000) + (theta = Math.toDegrees(Math.atan2(i, j)) * (double)0.01f), (double)(z * 10000) + theta, true) + 1.0) / 2.0, 0.5, 2.0) * (float)radius * (limit - distance) / limit)))) continue;
                mutable.set(offsetX, center.getY(), offsetZ);
                for (k = 0; k < verticalRange; ++k) {
                    if (level.isStateAtPosition((BlockPos)mutable, statePredicate)) continue;
                    mutable.move(Direction.UP);
                }
                for (k = 0; k <= verticalRange * 2; ++k) {
                    if (!level.isStateAtPosition((BlockPos)mutable, statePredicate)) continue;
                    mutable.move(Direction.DOWN);
                }
                BlockState state = level.getBlockState((BlockPos)mutable);
                if (!state.isFaceSturdy((BlockGetter)level, (BlockPos)mutable, Direction.UP)) continue;
                positions.add(mutable.immutable());
            }
        }
        return positions;
    }

    public static boolean canBeRemoved(BlockState state) {
        return state.canBeReplaced() || state.is(MalumTags.BlockTags.BLIGHT_REMOVABLE);
    }

    public static class LodestoneWorldgenBuilder {
        protected final ArrayList<LodestoneWorldgenBuilderLayer> layers = new ArrayList();
        protected PlacementCondition defaultPlacementCondition = (level, entry) -> true;
        protected AdditionalPlacement defaultAdditionalPlacement = (level, entry) -> {};

        public static LodestoneWorldgenBuilder create() {
            return new LodestoneWorldgenBuilder();
        }

        public LodestoneWorldgenBuilder addAdditionalPlacement(AdditionalPlacement defaultAdditionalPlacement) {
            this.defaultAdditionalPlacement = defaultAdditionalPlacement;
            return this;
        }

        public LodestoneWorldgenBuilder addPlacementCondition(PlacementCondition defaultPlacementCondition) {
            this.defaultPlacementCondition = defaultPlacementCondition;
            return this;
        }

        public LodestoneWorldgenBuilderLayer createLayer() {
            LodestoneWorldgenBuilderLayer layer = new LodestoneWorldgenBuilderLayer();
            layer.addAdditionalPlacement(this.defaultAdditionalPlacement);
            layer.addPlacementCondition(this.defaultPlacementCondition);
            this.layers.add(layer);
            return layer;
        }

        public ArrayList<LodestoneWorldgenBuilderLayer> getLayers() {
            return this.layers;
        }

        public LodestoneWorldgenBuilderLayer getLayer(int index) {
            return this.layers.get(index);
        }

        public ArrayList<BlockPos> getAffectedArea(int layerIndex) {
            return new ArrayList<BlockPos>(this.getLayer(layerIndex).getAffectedArea());
        }

        public ArrayList<BlockPos> getAffectedArea() {
            ArrayList<BlockPos> affectedArea = new ArrayList<BlockPos>();
            for (LodestoneWorldgenBuilderLayer layer : this.getLayers()) {
                affectedArea.addAll(layer.getAffectedArea());
            }
            return affectedArea;
        }

        public Collection<LodestoneWorldgenBuilderEntry> getEntries(int layerIndex) {
            return this.getLayer(layerIndex).getEntries();
        }

        public ArrayList<LodestoneWorldgenBuilderEntry> getAllEntries() {
            ArrayList<LodestoneWorldgenBuilderEntry> entries = new ArrayList<LodestoneWorldgenBuilderEntry>();
            for (LodestoneWorldgenBuilderLayer layer : this.getLayers()) {
                entries.addAll(layer.getEntries());
            }
            return entries;
        }

        public Collection<LodestoneWorldgenBuilderEntry> getOrderedEntries(int layerIndex) {
            return this.getLayer(layerIndex).getOrderedEntries();
        }

        public ArrayList<LodestoneWorldgenBuilderEntry> getOrderedEntries() {
            ArrayList<LodestoneWorldgenBuilderEntry> entries = new ArrayList<LodestoneWorldgenBuilderEntry>();
            for (LodestoneWorldgenBuilderLayer layer : this.getLayers()) {
                entries.addAll(layer.getOrderedEntries());
            }
            return entries;
        }

        public LodestoneWorldgenBuilder merge(LodestoneWorldgenBuilder other) {
            this.getLayers().addAll(other.getLayers());
            return this;
        }

        public void place(WorldGenLevel level) {
            HashSet<BlockPos> skippedPositions = new HashSet<BlockPos>();
            for (LodestoneWorldgenBuilderLayer layer : this.getLayers()) {
                for (LodestoneWorldgenBuilderEntry entry : layer.getOrderedEntries()) {
                    if (!entry.isImportant() && skippedPositions.contains(entry.position()) || !entry.tryPlace(level)) continue;
                    skippedPositions.add(entry.position());
                }
            }
        }
    }

    @FunctionalInterface
    public static interface AdditionalPlacement {
        public void place(WorldGenLevel var1, LodestoneWorldgenBuilderEntry var2);
    }

    public static class LodestoneWorldgenBuilderLayer {
        protected final HashMap<BlockPos, LodestoneWorldgenBuilderEntry> entries = new HashMap();
        protected final ArrayList<BlockPos> entryOrder = new ArrayList();
        protected PlacementCondition defaultPlacementCondition;
        protected AdditionalPlacement defaultAdditionalPlacement;

        public ArrayList<BlockPos> getAffectedArea() {
            return new ArrayList<BlockPos>(this.entries.keySet());
        }

        public LodestoneWorldgenBuilderLayer addAdditionalPlacement(AdditionalPlacement defaultAdditionalPlacement) {
            this.defaultAdditionalPlacement = defaultAdditionalPlacement;
            return this;
        }

        public LodestoneWorldgenBuilderLayer addPlacementCondition(PlacementCondition defaultPlacementCondition) {
            this.defaultPlacementCondition = defaultPlacementCondition;
            return this;
        }

        public LodestoneWorldgenBuilderLayer merge(LodestoneWorldgenBuilderLayer other) {
            this.entries.putAll(other.entries);
            return this;
        }

        public LodestoneWorldgenBuilderEntry add(BlockPos blockPos, Block block) {
            return this.add(blockPos, block.defaultBlockState());
        }

        public LodestoneWorldgenBuilderEntry add(BlockPos pos, BlockState state) {
            LodestoneWorldgenBuilderEntry entry;
            if (pos instanceof BlockPos.MutableBlockPos) {
                BlockPos.MutableBlockPos mutable = (BlockPos.MutableBlockPos)pos;
                pos = mutable.immutable();
            }
            if (!(entry = new LodestoneWorldgenBuilderEntry(pos, state)).hasPlacementCondition()) {
                entry.addPlacementCondition(this.defaultPlacementCondition);
            }
            if (!entry.hasAdditionalPlacement()) {
                entry.addAdditionalPlacement(this.defaultAdditionalPlacement);
            }
            this.add(pos, entry);
            return entry;
        }

        public LodestoneWorldgenBuilderLayer add(BlockPos pos, LodestoneWorldgenBuilderEntry entry) {
            this.entries.put(pos, entry);
            this.entryOrder.add(pos);
            return this;
        }

        public LodestoneWorldgenBuilderLayer remove(BlockPos pos) {
            this.entries.remove(pos);
            this.entryOrder.remove(pos);
            return this;
        }

        public LodestoneWorldgenBuilderEntry get(BlockPos pos) {
            return this.entries.get(pos);
        }

        public boolean containsKey(BlockPos pos) {
            return this.entries.containsKey(pos);
        }

        public Collection<LodestoneWorldgenBuilderEntry> getEntries() {
            return this.entries.values();
        }

        public ArrayList<LodestoneWorldgenBuilderEntry> getOrderedEntries() {
            ArrayList<LodestoneWorldgenBuilderEntry> orderedEntries = new ArrayList<LodestoneWorldgenBuilderEntry>();
            for (BlockPos pos : this.entryOrder) {
                orderedEntries.add(this.entries.get(pos));
            }
            return orderedEntries;
        }

        public ArrayList<LodestoneWorldgenBuilderEntry> getRandomEntries(int amount) {
            ArrayList<LodestoneWorldgenBuilderEntry> randomEntries = new ArrayList<LodestoneWorldgenBuilderEntry>();
            ArrayList<BlockPos> keys = new ArrayList<BlockPos>(this.entries.keySet());
            Collections.shuffle(keys);
            for (int i = 0; i < Math.min(amount, keys.size()); ++i) {
                randomEntries.add(this.entries.get(keys.get(i)));
            }
            return randomEntries;
        }
    }

    public static class LodestoneWorldgenBuilderEntry {
        protected BlockPos pos;
        protected BlockState state;
        protected PlacementCondition placementCondition;
        protected AdditionalPlacement additionalPlacement;
        protected boolean important;

        public LodestoneWorldgenBuilderEntry(BlockPos pos, BlockState state) {
            this.pos = pos;
            this.state = state;
        }

        public BlockPos position() {
            return this.pos;
        }

        public BlockState blockState() {
            return this.state;
        }

        public LodestoneWorldgenBuilderEntry changePos(Function<BlockPos, BlockPos> function) {
            return this.changePos(function.apply(this.pos));
        }

        public LodestoneWorldgenBuilderEntry changePos(BlockPos pos) {
            this.pos = pos;
            return this;
        }

        public LodestoneWorldgenBuilderEntry changeState(Function<BlockState, BlockState> function) {
            return this.changeState(function.apply(this.state));
        }

        public LodestoneWorldgenBuilderEntry changeState(BlockState state) {
            this.state = state;
            return this;
        }

        public LodestoneWorldgenBuilderEntry addPlacementCondition(PlacementCondition placementCondition) {
            this.placementCondition = placementCondition;
            return this;
        }

        public LodestoneWorldgenBuilderEntry addAdditionalPlacement(AdditionalPlacement additionalPlacement) {
            this.additionalPlacement = additionalPlacement;
            return this;
        }

        public LodestoneWorldgenBuilderEntry setImportant() {
            this.important = true;
            return this;
        }

        public boolean isImportant() {
            return this.important;
        }

        public boolean hasPlacementCondition() {
            return this.placementCondition != null;
        }

        public boolean hasAdditionalPlacement() {
            return this.additionalPlacement != null;
        }

        public boolean canPlace(WorldGenLevel level) {
            return this.placementCondition.canPlace(level, this);
        }

        public boolean tryPlace(WorldGenLevel level) {
            if (this.canPlace(level)) {
                this.place(level);
                this.additionalPlacement.place(level, this);
                return true;
            }
            return false;
        }

        public void place(WorldGenLevel level) {
            this.place(level, this.position(), this.blockState());
        }

        public void place(WorldGenLevel level, BlockPos pos, BlockState state) {
            level.setBlock(pos, state, 19);
            if (level instanceof Level) {
                Level realLevel = (Level)level;
                BlockStateHelper.updateState((Level)realLevel, (BlockPos)pos);
            }
        }
    }

    @FunctionalInterface
    public static interface PlacementCondition {
        public static final PlacementCondition CAN_SURVIVE = (level, entry) -> entry.blockState().canSurvive((LevelReader)level, entry.position());

        public boolean canPlace(WorldGenLevel var1, LodestoneWorldgenBuilderEntry var2);
    }
}

