/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.handlers.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sammy.malum.MalumMod;
import com.sammy.malum.common.data.attachment.SoulWardData;
import com.sammy.malum.registry.common.MalumAttachmentTypes;
import com.sammy.malum.registry.common.MalumAttributes;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.joml.Vector4f;
import team.lodestar.lodestone.registry.client.LodestoneShaders;
import team.lodestar.lodestone.systems.rendering.VFXBuilders;
import team.lodestar.lodestone.systems.rendering.shader.ExtendedShaderInstance;

public class SoulWardRenderHandler {
    public static int glow;

    public static void tick(ClientTickEvent event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            SoulWardData data = (SoulWardData)player.getData(MalumAttachmentTypes.SOUL_WARD);
            if (data.getSoulWard() >= player.getAttributeValue(MalumAttributes.SOUL_WARD_CAPACITY)) {
                if (glow < 20) {
                    ++glow;
                }
            } else if (glow > 0) {
                glow = Math.max(glow - 2, 0);
            }
        }
    }

    public static void renderSoulWard(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        SoulWardData data;
        double soulWard;
        LocalPlayer player;
        Minecraft minecraft = Minecraft.getInstance();
        PoseStack poseStack = guiGraphics.pose();
        if (!minecraft.options.hideGui && !(player = minecraft.player).isCreative() && !player.isSpectator() && (soulWard = (data = (SoulWardData)player.getData(MalumAttachmentTypes.SOUL_WARD)).getSoulWard()) > 0.0) {
            float armor = (float)player.getAttribute(Attributes.ARMOR).getValue();
            int left = guiGraphics.guiWidth() / 2 - 91;
            int top = guiGraphics.guiHeight() - minecraft.gui.leftHeight - 2;
            if (armor == 0.0f) {
                top += 10;
            }
            poseStack.pushPose();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)SoulWardRenderHandler.getSoulWardTexture());
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            ExtendedShaderInstance shaderInstance = (ExtendedShaderInstance)LodestoneShaders.SCREEN_DISTORTED_TEXTURE.getInstance().get();
            shaderInstance.safeGetUniform("YFrequency").set(15.0f);
            shaderInstance.safeGetUniform("XFrequency").set(15.0f);
            shaderInstance.safeGetUniform("Speed").set(550.0f);
            shaderInstance.safeGetUniform("Intensity").set(120.0f);
            VFXBuilders.ScreenVFXBuilder builder = VFXBuilders.createScreen().setShader(() -> shaderInstance);
            int size = 13;
            boolean forceDisplay = soulWard <= 1.0;
            double soulWardAmount = forceDisplay ? 1.0 : Math.ceil(Math.floor(soulWard) / 3.0);
            int i = 0;
            while ((double)i < soulWardAmount) {
                int row = Mth.floor((float)((float)i / 10.0f));
                int x = left + i % 10 * 8;
                int y = top - row * 4;
                int progress = Math.min(3, (int)soulWard - i * 3);
                int xTextureOffset = forceDisplay ? 31 : 1 + (3 - progress) * 15;
                shaderInstance.safeGetUniform("UVCoordinates").set(new Vector4f((float)xTextureOffset / 45.0f, (float)(xTextureOffset + size) / 45.0f, 0.0f, 0.33333334f));
                shaderInstance.safeGetUniform("TimeOffset").set((float)i * 150.0f);
                builder.setAlpha(1.0f).setPositionWithWidth((float)(x - 2), (float)(y - 2), (float)size, (float)size).setUVWithWidth((float)xTextureOffset, 0.0f, (float)size, (float)size, 45.0f);
                builder.blit(poseStack);
                if (glow > 0 && glow < 20) {
                    float alpha = (float)(10 - Math.abs(10 - glow)) / 10.0f;
                    RenderSystem.blendFunc((int)770, (int)1);
                    builder.setAlpha(alpha).blit(poseStack).setAlpha(1);
                    RenderSystem.defaultBlendFunc();
                }
                ++i;
            }
            shaderInstance.setUniformDefaults();
            RenderSystem.disableBlend();
            poseStack.popPose();
        }
    }

    public static ResourceLocation getSoulWardTexture() {
        return MalumMod.malumPath("textures/gui/hud/soul_ward.png");
    }
}

