/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.artifice;

import com.sammy.malum.core.systems.artifice.ArtificeAttributeData;
import com.sammy.malum.core.systems.artifice.ArtificeAttributeValue;

public abstract class TuningBehavior {
    public static final TuningBehavior STANDARD = new TuningBehavior(){

        @Override
        public float getMultiplier(boolean isPositive) {
            return isPositive ? 0.2f : -0.1f;
        }

        @Override
        public float getRelativeValue(ArtificeAttributeData data, ArtificeAttributeValue artificeAttributeValue) {
            return artificeAttributeValue.getValue(data);
        }
    };
    public static final TuningBehavior INVERSE = new TuningBehavior(){

        @Override
        public float getMultiplier(boolean isPositive) {
            return isPositive ? -0.2f : 0.1f;
        }

        @Override
        public float getRelativeValue(ArtificeAttributeData data, ArtificeAttributeValue artificeAttributeValue) {
            return artificeAttributeValue.getValue(data);
        }
    };

    public abstract float getRelativeValue(ArtificeAttributeData var1, ArtificeAttributeValue var2);

    public abstract float getMultiplier(boolean var1);

    public float getPositiveMultiplier() {
        return this.getMultiplier(true);
    }

    public float getNegativeMultiplier() {
        return this.getMultiplier(false);
    }
}

