/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.item;

import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.ItemStack;

public class HeldItemTracker {
    public final Predicate<ItemStack> predicate;
    public int heldTimer;
    public boolean isHeld;
    public static final ArrayList<HeldItemTracker> TRACKERS = new ArrayList();

    public HeldItemTracker(Predicate<ItemStack> predicate) {
        this.predicate = predicate;
        TRACKERS.add(this);
    }

    public static void tickTrackers() {
        for (HeldItemTracker tracker : TRACKERS) {
            tracker.update();
        }
    }

    public void update() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (this.predicate.test(player.getMainHandItem()) || this.predicate.test(player.getOffhandItem())) {
            if (this.heldTimer < 20) {
                ++this.heldTimer;
            }
            this.isHeld = true;
        } else if (this.heldTimer > 0) {
            --this.heldTimer;
            this.isHeld = false;
        }
    }

    public boolean isVisible() {
        return this.getDelta(0.0f) > 0.0f;
    }

    public float getDelta(float partialTicks) {
        return ((float)this.heldTimer + (this.isHeld ? partialTicks : -partialTicks)) / 20.0f;
    }
}

