/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.rite;

import com.sammy.malum.common.block.curiosities.totem.TotemBaseBlockEntity;
import com.sammy.malum.registry.common.MalumTags;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import team.lodestar.lodestone.helpers.block.BlockPosHelper;

public abstract class TotemicRiteEffect {
    public final MalumRiteEffectCategory category;

    protected TotemicRiteEffect(MalumRiteEffectCategory category) {
        this.category = category;
    }

    public final void doRiteEffect(TotemBaseBlockEntity totemBase) {
        Level level = totemBase.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.doRiteEffect(totemBase, serverLevel);
        }
    }

    protected abstract void doRiteEffect(TotemBaseBlockEntity var1, ServerLevel var2);

    public BlockPos getRiteEffectCenter(TotemBaseBlockEntity totemBase) {
        if (this.category.equals((Object)MalumRiteEffectCategory.DIRECTIONAL_BLOCK_EFFECT)) {
            return totemBase.getBlockPos().below().relative(totemBase.getDirection(), 3);
        }
        return totemBase.getBlockPos();
    }

    public String getRiteCoverageDescriptor() {
        int yCoverage;
        int coverage = this.getRiteEffectHorizontalRadius();
        if (coverage > 1) {
            coverage = coverage * 2 + 1;
        }
        if ((yCoverage = this.getRiteEffectVerticalRadius()) > 1) {
            yCoverage = yCoverage * 2 + 1;
        }
        return coverage + "x" + yCoverage + "x" + coverage;
    }

    public int getRiteEffectHorizontalRadius() {
        return this.category.effectWidth;
    }

    public int getRiteEffectVerticalRadius() {
        return this.category.effectHeight;
    }

    public int getRiteEffectTickRate() {
        return this.category.tickRate;
    }

    public <T extends Entity> Stream<T> getNearbyEntities(TotemBaseBlockEntity totemBase, Class<T> clazz) {
        return this.getNearbyEntities(totemBase, clazz, e -> true);
    }

    public <T extends Entity> Stream<T> getNearbyEntities(TotemBaseBlockEntity totemBase, Class<T> clazz, Predicate<T> predicate) {
        int horizontal = this.getRiteEffectHorizontalRadius();
        int vertical = this.getRiteEffectVerticalRadius();
        AABB area = new AABB(this.getRiteEffectCenter(totemBase)).inflate((double)horizontal, (double)vertical, (double)horizontal);
        return totemBase.getLevel().getEntitiesOfClass(clazz, area).stream().filter(predicate);
    }

    public Stream<BlockPos> getNearbyBlocks(TotemBaseBlockEntity totemBase, Class<?> clazz) {
        int horizontal = this.getRiteEffectHorizontalRadius();
        int vertical = this.getRiteEffectVerticalRadius();
        return BlockPosHelper.getBlocksStream((BlockPos)this.getRiteEffectCenter(totemBase), (int)horizontal, (int)vertical, (int)horizontal, p -> this.canAffectBlock(totemBase, clazz, (BlockPos)p));
    }

    public Stream<BlockPos> getBlocksAhead(TotemBaseBlockEntity totemBase) {
        return BlockPosHelper.getPlaneOfBlocksStream((BlockPos)this.getRiteEffectCenter(totemBase), (int)this.getRiteEffectHorizontalRadius(), p -> this.canAffectBlock(totemBase, (BlockPos)p));
    }

    public final boolean canAffectBlock(TotemBaseBlockEntity totemBase, Class<?> clazz, BlockPos pos) {
        BlockState state = totemBase.getLevel().getBlockState(pos);
        return clazz.isInstance(state.getBlock()) && this.canAffectBlock(totemBase, state, pos);
    }

    public final boolean canAffectBlock(TotemBaseBlockEntity totemBase, BlockPos pos) {
        BlockState state = totemBase.getLevel().getBlockState(pos);
        return this.canAffectBlock(totemBase, state, pos);
    }

    public boolean canAffectBlock(TotemBaseBlockEntity totemBase, BlockState state, BlockPos pos) {
        return !state.is(MalumTags.BlockTags.IS_RITE_IMMUNE);
    }

    public static enum MalumRiteEffectCategory {
        AURA(40, 8),
        LIVING_ENTITY_EFFECT(40, 4),
        DIRECTIONAL_BLOCK_EFFECT(160, 2, 1),
        RADIAL_BLOCK_EFFECT(80, 5),
        ONE_TIME_EFFECT(0, 0);

        private final int tickRate;
        private final int effectWidth;
        private final int effectHeight;

        private MalumRiteEffectCategory(int tickRate, int range) {
            this(tickRate, range, range);
        }

        private MalumRiteEffectCategory(int tickRate, int effectWidth, int effectHeight) {
            this.tickRate = tickRate;
            this.effectWidth = effectWidth;
            this.effectHeight = effectHeight;
        }

        public String getTranslationKey() {
            return "malum.gui.rite.category." + this.name().toLowerCase(Locale.ROOT);
        }
    }
}

