/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.sammy.malum.config.CommonConfig;
import com.sammy.malum.core.listeners.SpiritDataReloadListener;
import com.sammy.malum.core.systems.recipe.SpiritIngredient;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class EntitySpiritDropData {
    public static final EntitySpiritDropData EMPTY = new EntitySpiritDropData(MalumSpiritTypes.SACRED_SPIRIT, new ArrayList<SpiritIngredient>(), null);
    protected final MalumSpiritType primaryType;
    protected final int totalSpirits;
    protected final List<SpiritIngredient> spirits;
    protected final List<ItemStack> spiritStacks;
    @Nullable
    protected final Ingredient itemAsSoul;

    public EntitySpiritDropData(MalumSpiritType primaryType, List<SpiritIngredient> spirits, @Nullable Ingredient itemAsSoul) {
        this.primaryType = primaryType;
        this.totalSpirits = spirits.stream().mapToInt(SpiritIngredient::getCount).sum();
        this.spirits = spirits;
        this.spiritStacks = spirits.stream().map(SpiritIngredient::getStack).collect(Collectors.toList());
        this.itemAsSoul = itemAsSoul;
    }

    public static List<ItemStack> getSpiritStacks(LivingEntity entity) {
        return EntitySpiritDropData.getSpiritData(entity).map(EntitySpiritDropData::getSpiritStacks).orElse(Collections.emptyList());
    }

    public MalumSpiritType getPrimaryType() {
        return this.primaryType;
    }

    public int getTotalSpirits() {
        return this.totalSpirits;
    }

    public List<SpiritIngredient> getSpirits() {
        return this.spirits;
    }

    public List<ItemStack> getSpiritStacks() {
        return this.spiritStacks;
    }

    @Nullable
    public Ingredient getItemAsSoul() {
        return this.itemAsSoul;
    }

    public static Optional<EntitySpiritDropData> getSpiritData(LivingEntity entity) {
        ResourceLocation key = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (SpiritDataReloadListener.HAS_NO_DATA.contains(key)) {
            return Optional.empty();
        }
        EntitySpiritDropData spiritData = SpiritDataReloadListener.SPIRIT_DATA.get(key);
        if (spiritData != null) {
            return Optional.of(spiritData);
        }
        if (entity.getMaxHealth() >= 60.0f) {
            return Optional.of(SpiritDataReloadListener.DEFAULT_BOSS_SPIRIT_DATA);
        }
        if (!((Boolean)CommonConfig.USE_DEFAULT_SPIRIT_VALUES.getConfigValue()).booleanValue()) {
            return Optional.empty();
        }
        return switch (entity.getType().getCategory()) {
            case MobCategory.MONSTER -> Optional.of(SpiritDataReloadListener.DEFAULT_MONSTER_SPIRIT_DATA);
            case MobCategory.CREATURE -> Optional.of(SpiritDataReloadListener.DEFAULT_CREATURE_SPIRIT_DATA);
            case MobCategory.AMBIENT -> Optional.of(SpiritDataReloadListener.DEFAULT_AMBIENT_SPIRIT_DATA);
            case MobCategory.AXOLOTLS -> Optional.of(SpiritDataReloadListener.DEFAULT_AXOLOTL_SPIRIT_DATA);
            case MobCategory.UNDERGROUND_WATER_CREATURE -> Optional.of(SpiritDataReloadListener.DEFAULT_UNDERGROUND_WATER_CREATURE_SPIRIT_DATA);
            case MobCategory.WATER_CREATURE -> Optional.of(SpiritDataReloadListener.DEFAULT_WATER_CREATURE_SPIRIT_DATA);
            case MobCategory.WATER_AMBIENT -> Optional.of(SpiritDataReloadListener.DEFAULT_WATER_AMBIENT_SPIRIT_DATA);
            default -> Optional.empty();
        };
    }

    public static Builder builder(MalumSpiritType type) {
        return EntitySpiritDropData.builder(type, 1);
    }

    public static Builder builder(MalumSpiritType type, int count) {
        return new Builder(type).withSpirit(type, count);
    }

    public static class Builder {
        private final MalumSpiritType type;
        private final List<SpiritIngredient> spirits = new ArrayList<SpiritIngredient>();
        private Ingredient itemAsSoul = null;

        public Builder(MalumSpiritType type) {
            this.type = type;
        }

        public Builder withSpirit(MalumSpiritType spiritType) {
            return this.withSpirit(spiritType, 1);
        }

        public Builder withSpirit(MalumSpiritType spiritType, int count) {
            this.spirits.add(new SpiritIngredient(spiritType, count));
            return this;
        }

        public Builder withItemAsSoul(Ingredient itemAsSoul) {
            this.itemAsSoul = itemAsSoul;
            return this;
        }

        public EntitySpiritDropData build() {
            return new EntitySpiritDropData(this.type, this.spirits, this.itemAsSoul);
        }
    }
}

