/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.spirit;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.level.block.state.properties.Property;

public class SpiritTypeProperty
extends Property<String> {
    private final ImmutableSet<String> values;
    private final Map<String, MalumSpiritType> types = Maps.newHashMap();

    public SpiritTypeProperty(String name, Collection<MalumSpiritType> types) {
        super(name, String.class);
        this.values = ImmutableSet.copyOf((Collection)types.stream().map(s -> s.identifier).collect(Collectors.toList()));
        for (MalumSpiritType type : types) {
            if (this.types.containsKey(type.identifier)) {
                throw new IllegalArgumentException("Multiple values have the same name '" + type.identifier + "'");
            }
            this.types.put(type.identifier, type);
        }
    }

    public Collection<String> getPossibleValues() {
        return this.values;
    }

    public Optional<String> getValue(String value) {
        return this.values.stream().filter(v -> v.equals(value)).findAny();
    }

    public String getName(String value) {
        return value;
    }

    public boolean equals(Object pOther) {
        if (this == pOther) {
            return true;
        }
        if (pOther instanceof SpiritTypeProperty) {
            SpiritTypeProperty property = (SpiritTypeProperty)((Object)pOther);
            if (super.equals(pOther)) {
                return this.values.equals(property.values) && this.types.equals(property.types);
            }
        }
        return false;
    }

    public int generateHashCode() {
        int i = super.generateHashCode();
        i = 31 * i + this.values.hashCode();
        return 31 * i + this.types.hashCode();
    }
}

