/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.block;

import com.sammy.malum.common.block.ether.EtherBlock;
import com.sammy.malum.common.block.storage.jar.SpiritJarBlock;
import com.sammy.malum.registry.common.block.MalumBlocks;
import com.sammy.malum.registry.common.item.MalumDataComponents;
import com.sammy.malum.registry.common.item.MalumItems;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.CopyNameFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.AnyOfCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.registries.DeferredHolder;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.block.LodestoneBlockProperties;

public class MalumBlockLootTables
extends LootTableProvider {
    private static final float[] MAGIC_SAPLING_DROP_CHANCE = new float[]{0.015f, 0.0225f, 0.033333335f, 0.05f};
    private static final Function<Block, LootItemCondition.Builder> IS_UPPER_PART = Util.memoize(b -> AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)b).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)), LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{b}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER))), (BlockPos)new BlockPos(0, -1, 0))}));
    private static final Function<Block, LootItemCondition.Builder> IS_LOWER_PART = Util.memoize(b -> AllOfCondition.allOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)b).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)), LocationCheck.checkLocation((LocationPredicate.Builder)LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{b}).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.UPPER))), (BlockPos)new BlockPos(0, 1, 0))}));

    public MalumBlockLootTables(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> provider) {
        super(pOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlocksLoot::new, LootContextParamSets.BLOCK)), provider);
    }

    public static class BlocksLoot
    extends BlockLootSubProvider {
        protected BlocksLoot(HolderLookup.Provider provider) {
            super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
        }

        protected Iterable<Block> getKnownBlocks() {
            return MalumBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }

        protected void generate() {
            HashSet blocks = new HashSet(MalumBlocks.BLOCKS.getEntries());
            DataHelper.takeAll(blocks, b -> {
                BlockBehaviour.Properties patt0$temp = ((Block)b.get()).properties();
                if (patt0$temp instanceof LodestoneBlockProperties) {
                    LodestoneBlockProperties properties = (LodestoneBlockProperties)patt0$temp;
                    return properties.getDatagenData().noLootDatagen;
                }
                return true;
            });
            DataHelper.takeAll(blocks, (Object[])new DeferredHolder[]{MalumBlocks.RUNEWOOD_LEAVES, MalumBlocks.HANGING_RUNEWOOD_LEAVES}).forEach(b -> this.add((Block)b.get(), this.createLeavesDrops((Block)b.get(), (Block)MalumBlocks.RUNEWOOD_SAPLING.get(), MAGIC_SAPLING_DROP_CHANCE)));
            DataHelper.takeAll(blocks, (Object[])new DeferredHolder[]{MalumBlocks.AZURE_RUNEWOOD_LEAVES, MalumBlocks.HANGING_AZURE_RUNEWOOD_LEAVES}).forEach(b -> this.add((Block)b.get(), this.createLeavesDrops((Block)b.get(), (Block)MalumBlocks.AZURE_RUNEWOOD_SAPLING.get(), MAGIC_SAPLING_DROP_CHANCE)));
            DataHelper.takeAll(blocks, (Object[])new DeferredHolder[]{MalumBlocks.SOULWOOD_LEAVES, MalumBlocks.HANGING_SOULWOOD_LEAVES}).forEach(b -> this.add((Block)b.get(), this.createLeavesDrops((Block)b.get(), (Block)MalumBlocks.SOULWOOD_SAPLING.get(), MAGIC_SAPLING_DROP_CHANCE)));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.STRANGE_CRYSTAL)).get(), this.createSingleItemTableWithSilkTouchOrShears((Block)MalumBlocks.STRANGE_CRYSTAL.get(), (ItemLike)MalumItems.STRANGE_CRYSTAL.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.LARGE_STRANGE_CRYSTAL)).get(), this.createTallBlockDrop((Block)MalumBlocks.LARGE_STRANGE_CRYSTAL.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.STRANGEROOT)).get(), this.createSingleItemTableWithSilkTouchOrShears((Block)MalumBlocks.STRANGEROOT.get(), (ItemLike)MalumItems.STRANGEROOT.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.BLIGHTED_SOULWOOD)).get(), this.createSingleItemTableWithSilkTouch((Block)MalumBlocks.BLIGHTED_SOULWOOD.get(), (ItemLike)MalumItems.SOULWOOD_LOG.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.BLIGHTED_EARTH)).get(), this.createBlightedDrop((Block)MalumBlocks.BLIGHTED_EARTH.get(), 4));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.BLIGHTED_GROWTH)).get(), this.createBlightedPlantDrop((Block)MalumBlocks.BLIGHTED_GROWTH.get(), 1));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.BLIGHTPEARL)).get(), this.createBlightedPlantDrop((Block)MalumBlocks.BLIGHTPEARL.get(), 1));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.BLIGHTROOT)).get(), this.createBlightedPlantDrop((Block)MalumBlocks.BLIGHTROOT.get(), 1));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.BRILLIANT_STONE)).get(), this.createOreDrop((Block)MalumBlocks.BRILLIANT_STONE.get(), (Item)MalumItems.RAW_BRILLIANCE.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.BRILLIANT_DEEPSLATE)).get(), this.createOreDrop((Block)MalumBlocks.BRILLIANT_DEEPSLATE.get(), (Item)MalumItems.RAW_BRILLIANCE.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.SOULSTONE_ORE)).get(), this.createOreDrop((Block)MalumBlocks.SOULSTONE_ORE.get(), (Item)MalumItems.RAW_SOULSTONE.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.DEEPSLATE_SOULSTONE_ORE)).get(), this.createOreDrop((Block)MalumBlocks.DEEPSLATE_SOULSTONE_ORE.get(), (Item)MalumItems.RAW_SOULSTONE.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.BLAZING_QUARTZ_ORE)).get(), this.createOreDrop((Block)MalumBlocks.BLAZING_QUARTZ_ORE.get(), (Item)MalumItems.BLAZING_QUARTZ.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.NATURAL_QUARTZ_ORE)).get(), this.createOreDrop((Block)MalumBlocks.NATURAL_QUARTZ_ORE.get(), (Item)MalumItems.NATURAL_QUARTZ.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.DEEPSLATE_QUARTZ_ORE)).get(), this.createOreDrop((Block)MalumBlocks.DEEPSLATE_QUARTZ_ORE.get(), (Item)MalumItems.NATURAL_QUARTZ.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.CTHONIC_GOLD_ORE)).get(), this.createCthonicGoldOreDrop((Block)MalumBlocks.CTHONIC_GOLD_ORE.get()));
            this.add((Block)((DeferredHolder)DataHelper.take(blocks, MalumBlocks.SOULWOVEN_BANNER)).get(), this.createBannerDrop((Block)MalumBlocks.SOULWOVEN_BANNER.get()));
            DataHelper.takeAll(blocks, b -> b.get() instanceof FlowerPotBlock).forEach(b -> this.add((Block)b.get(), this.createPotFlowerItemTable((ItemLike)((FlowerPotBlock)b.get()).getPotted())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof SaplingBlock).forEach(b -> this.add((Block)b.get(), this.createSingleItemTable((ItemLike)((Block)b.get()).asItem())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof DoublePlantBlock).forEach(b -> this.add((Block)b.get(), this.createSingleItemTableWithSilkTouchOrShears((Block)b.get(), (ItemLike)((Block)b.get()).asItem())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof BushBlock).forEach(b -> this.add((Block)b.get(), this.createSingleItemTableWithSilkTouchOrShears((Block)b.get(), (ItemLike)((Block)b.get()).asItem())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof GrassBlock).forEach(b -> this.add((Block)b.get(), this.createSingleItemTableWithSilkTouch((Block)b.get(), (ItemLike)Items.DIRT)));
            DataHelper.takeAll(blocks, b -> b.get() instanceof SlabBlock).forEach(b -> this.add((Block)b.get(), this.createSlabItemTable((Block)b.get())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof DoorBlock).forEach(b -> this.add((Block)b.get(), this.createDoorTable((Block)b.get())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof EtherBlock).forEach(b -> this.add((Block)b.get(), this.createEtherDrop((Block)b.get())));
            DataHelper.takeAll(blocks, b -> b.get() instanceof SpiritJarBlock).forEach(b -> this.add((Block)b.get(), this.createJarDrop((Block)b.get())));
            DataHelper.takeAll(blocks, b -> true).forEach(b -> this.add((Block)b.get(), this.createSingleItemTable((ItemLike)((Block)b.get()).asItem())));
        }

        protected LootTable.Builder createTallBlockDrop(Block block) {
            LootItemCondition.Builder upperCondition = IS_UPPER_PART.apply(block);
            LootItemCondition.Builder lowerCondition = IS_LOWER_PART.apply(block);
            return this.createSilkTouchDispatchTable(block, LootItem.lootTableItem((ItemLike)block).when((LootItemCondition.Builder)AnyOfCondition.anyOf((LootItemCondition.Builder[])new LootItemCondition.Builder[]{upperCondition, lowerCondition})));
        }

        protected LootTable.Builder createCthonicGoldOreDrop(Block block) {
            return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)block, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)MalumItems.CTHONIC_GOLD_FRAGMENT.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)3.0f, (float)4.0f)))));
        }

        protected LootTable.Builder createBlightedDrop(Block block, int gunkAmount) {
            return this.createSilkTouchDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)MalumItems.BLIGHTED_GUNK.get(), (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)MalumItems.BLIGHTED_GUNK.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)gunkAmount)))));
        }

        protected LootTable.Builder createBlightedPlantDrop(Block block, int gunkAmount) {
            return this.createSilkTouchOrShearsDispatchTable(block, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)MalumItems.BLIGHTED_GUNK.get(), (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)((ItemLike)MalumItems.BLIGHTED_GUNK.get())).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)gunkAmount)))));
        }

        protected LootTable.Builder createEtherDrop(Block block) {
            return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)MalumDataComponents.SECONDARY_DYED_COLOR.get()).include(DataComponents.DYED_COLOR)))));
        }

        protected LootTable.Builder createBannerDrop(Block block) {
            return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)MalumDataComponents.SOULWOVEN_BANNER_PATTERN.get())))));
        }

        protected LootTable.Builder createJarDrop(Block block) {
            return LootTable.lootTable().withPool((LootPool.Builder)this.applyExplosionCondition((ItemLike)block, (ConditionUserBuilder)LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block).apply((LootItemFunction.Builder)CopyNameFunction.copyName((CopyNameFunction.NameSource)CopyNameFunction.NameSource.BLOCK_ENTITY)).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include((DataComponentType)MalumDataComponents.SPIRIT_JAR_CONTENTS.get())))));
        }

        protected LootTable.Builder createSingleItemTableWithSilkTouchOrShears(Block p_124258_, ItemLike p_124259_) {
            return this.createSilkTouchOrShearsDispatchTable(p_124258_, (LootPoolEntryContainer.Builder)this.applyExplosionCondition((ItemLike)p_124258_, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)p_124259_)));
        }
    }
}

