/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.block;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.blight.BlightedCoverageBlock;
import com.sammy.malum.common.block.blight.CreepingBlightBlock;
import com.sammy.malum.common.block.blight.scarstone.LargeStrangeCrystalBlock;
import com.sammy.malum.common.block.curiosities.banner.SoulwovenBannerBlock;
import com.sammy.malum.common.block.curiosities.redstone.SpiritDiodeBlock;
import com.sammy.malum.common.block.curiosities.repair_pylon.RepairPylonComponentBlock;
import com.sammy.malum.common.block.curiosities.totem.TotemPoleBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.PrimordialSoupBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.encasement.WeepingWellBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.encasement.WeepingWellDirectionalBlock;
import com.sammy.malum.common.block.curiosities.weeping_well.encasement.WeepingWellLayeredBlock;
import com.sammy.malum.common.block.ether.EtherBrazierBlock;
import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.datagen.item.MalumItemModelSmithTypes;
import com.sammy.malum.registry.common.MalumSpiritTypes;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import net.neoforged.neoforge.client.model.generators.VariantBlockStateBuilder;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmith;
import team.lodestar.lodestone.systems.datagen.statesmith.BlockStateSmith;

public class MalumBlockStateSmithTypes {
    public static BlockStateSmith<FlowerPotBlock> POTTED_PLANT = new BlockStateSmith(FlowerPotBlock.class, MalumItemModelSmithTypes.NO_DATAGEN, (block, provider) -> {
        String name = provider.getBlockName(block);
        ResourceLocation texture = provider.getBlockTexture(name.replace("potted_", ""));
        provider.simpleBlock(block, (ModelFile)((BlockModelBuilder)provider.models().withExistingParent(name, ResourceLocation.withDefaultNamespace((String)"block/flower_pot_cross"))).texture("plant", texture));
    });
    public static BlockStateSmith<BlightedCoverageBlock> COVERING_BLOCK = new BlockStateSmith(BlightedCoverageBlock.class, ItemModelSmithTypes.BLOCK_TEXTURE_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        ModelBuilder model = ((BlockModelBuilder)provider.models().withExistingParent(name, MalumMod.malumPath("block/templates/template_covering"))).texture("covering", provider.getBlockTexture(name));
        MultiPartBlockStateBuilder multipartBuilder = provider.getMultipartBuilder(block);
        for (Direction direction : Direction.values()) {
            BooleanProperty property = (BooleanProperty)block.defaultBlockState().getProperties().stream().filter(p -> p.getName().equals(direction.getName())).findFirst().orElseThrow();
            int yRotation = ((int)direction.toYRot() + 180) % 360;
            int xRotation = 0;
            if (direction.getAxis().isVertical()) {
                xRotation = direction.equals((Object)Direction.UP) ? 270 : 90;
            }
            ((MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)model).rotationY(yRotation).rotationX(xRotation).addModel()).condition((Property)property, (Comparable[])new Boolean[]{true}).end();
            MultiPartBlockStateBuilder.PartBuilder partBuilder = (MultiPartBlockStateBuilder.PartBuilder)multipartBuilder.part().modelFile((ModelFile)model).rotationY(yRotation).rotationX(xRotation).addModel();
            for (Direction again : Direction.values()) {
                property = (BooleanProperty)block.defaultBlockState().getProperties().stream().filter(p -> p.getName().equals(again.getName())).findFirst().orElseThrow();
                partBuilder.condition((Property)property, (Comparable[])new Boolean[]{false});
            }
            partBuilder.end();
        }
    });
    public static BlockStateSmith<TotemPoleBlock> TOTEM_POLE = new BlockStateSmith(TotemPoleBlock.class, ItemModelSmithTypes.NO_DATAGEN, (block, provider) -> {
        String name = provider.getBlockName(block);
        String woodName = name.substring(0, 8);
        ResourceLocation parent = MalumMod.malumPath("block/templates/template_totem_pole");
        ResourceLocation side = provider.getBlockTexture(woodName + "_log");
        ResourceLocation top = provider.getBlockTexture(woodName + "_log_top");
        provider.getVariantBuilder(block).forAllStates(s -> {
            String type = (String)((Object)s.getValue((Property)MalumSpiritTypes.SPIRIT_TYPE_PROPERTY));
            MalumSpiritType spiritType = MalumSpiritTypes.SPIRITS.get(type);
            ResourceLocation front = provider.modLoc("block/totem_poles/" + spiritType.getIdentifier() + "_" + woodName + "_cutout");
            ModelBuilder pole = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_" + spiritType.getIdentifier(), parent)).texture("side", side)).texture("top", top)).texture("front", front);
            return ConfiguredModel.builder().modelFile((ModelFile)pole).rotationY(((int)((Direction)s.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build();
        });
    });
    public static BlockStateSmith<SoulwovenBannerBlock> SOULWOVEN_BANNER = new BlockStateSmith(SoulwovenBannerBlock.class, MalumItemModelSmithTypes.SOULWOVEN_BANNER, (block, provider) -> {
        ResourceLocation hanging = MalumMod.malumPath("block/soulwoven_banner");
        ResourceLocation mounted = MalumMod.malumPath("block/soulwoven_banner_directional");
        provider.getVariantBuilder(block).forAllStates(s -> {
            SoulwovenBannerBlock.BannerType value = (SoulwovenBannerBlock.BannerType)((Object)((Object)((Object)s.getValue(SoulwovenBannerBlock.BANNER_TYPE))));
            boolean isVertical = value.direction.getAxis().isVertical();
            Direction direction = isVertical ? (value.equals((Object)SoulwovenBannerBlock.BannerType.HANGING_Z) ? Direction.NORTH : Direction.WEST) : value.direction;
            ResourceLocation model = isVertical ? hanging : mounted;
            return ConfiguredModel.builder().modelFile((ModelFile)provider.models().getExistingFile(model)).rotationY((int)direction.toYRot() % 360).build();
        });
    });
    public static BlockStateSmith<SpiritDiodeBlock> SPIRIT_DIODE = new BlockStateSmith(SpiritDiodeBlock.class, ItemModelSmithTypes.BLOCK_MODEL_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        ResourceLocation top = provider.getBlockTexture("runewood_frame_top");
        ResourceLocation opened = provider.getBlockTexture("runewood_frame_top_open");
        ResourceLocation bottom = provider.getBlockTexture("runewood_frame_bottom");
        ResourceLocation locked = provider.getBlockTexture("runewood_frame_locked");
        ResourceLocation input = provider.getBlockTexture("runewood_frame_input");
        ResourceLocation output = provider.getBlockTexture(name + "_output");
        BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)provider.models().cube(name, bottom, top, output, input, locked, locked)).texture("particle", output);
        BlockModelBuilder openModel = (BlockModelBuilder)((BlockModelBuilder)provider.models().cube(name + "_open", bottom, opened, output, input, locked, locked)).texture("particle", output);
        provider.getVariantBuilder(block).forAllStates(s -> {
            Direction direction = (Direction)s.getValue((Property)SpiritDiodeBlock.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)((Boolean)s.getValue((Property)SpiritDiodeBlock.OPEN) != false ? openModel : model)).rotationY((int)direction.toYRot() % 360).build();
        });
    });
    public static BlockStateSmith<RepairPylonComponentBlock> REPAIR_PYLON_COMPONENT = new BlockStateSmith(RepairPylonComponentBlock.class, ItemModelSmithTypes.NO_DATAGEN, (block, provider) -> {
        ModelFile.ExistingModelFile model = provider.models().getExistingFile(MalumMod.malumPath("block/repair_pylon_component_middle"));
        ModelFile.ExistingModelFile topModel = provider.models().getExistingFile(MalumMod.malumPath("block/repair_pylon_component_top"));
        provider.getVariantBuilder(block).forAllStates(arg_0 -> MalumBlockStateSmithTypes.lambda$static$10((ModelFile)topModel, (ModelFile)model, arg_0));
    });
    public static BlockStateSmith<WeepingWellBlock> WEEPING_WELL_BLOCK = new BlockStateSmith(WeepingWellBlock.class, MalumItemModelSmithTypes.WEEPING_WELL_BLOCK_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        ModelFile.ExistingModelFile model = provider.models().getExistingFile(MalumMod.malumPath("block/weeping_well/" + name));
        provider.getVariantBuilder(block).forAllStates(arg_0 -> MalumBlockStateSmithTypes.lambda$static$12((ModelFile)model, arg_0));
    });
    public static BlockStateSmith<WeepingWellLayeredBlock> WEEPING_WELL_LAYERED_BLOCK = new BlockStateSmith(WeepingWellLayeredBlock.class, MalumItemModelSmithTypes.LAYERED_WEEPING_WELL_BLOCK_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        provider.getVariantBuilder(block).forAllStates(s -> {
            ModelFile.ExistingModelFile model = provider.models().getExistingFile(MalumMod.malumPath("block/weeping_well/" + name + "_" + String.valueOf(s.getValue((Property)WeepingWellLayeredBlock.LAYER))));
            Direction direction = (Direction)s.getValue((Property)WeepingWellLayeredBlock.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY((int)(direction.toYRot() % 360.0f)).build();
        });
    });
    public static BlockStateSmith<WeepingWellDirectionalBlock> WEEPING_WELL_DIRECTIONAL_BLOCK = new BlockStateSmith(WeepingWellDirectionalBlock.class, MalumItemModelSmithTypes.WEEPING_WELL_BLOCK_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        ModelFile.ExistingModelFile model = provider.models().getExistingFile(MalumMod.malumPath("block/weeping_well/" + name));
        provider.getVariantBuilder(block).forAllStates(arg_0 -> MalumBlockStateSmithTypes.lambda$static$16((ModelFile)model, arg_0));
    });
    public static BlockStateSmith<PrimordialSoupBlock> PRIMORDIAL_SOUP = new BlockStateSmith(PrimordialSoupBlock.class, (ItemModelSmith)ItemModelSmithTypes.BLOCK_MODEL_ITEM.addTextureNameAffix("_top"), (block, provider) -> {
        String name = provider.getBlockName(block);
        ModelBuilder model = ((BlockModelBuilder)provider.models().withExistingParent(name, ResourceLocation.withDefaultNamespace((String)"block/powder_snow"))).texture("texture", MalumMod.malumPath("block/weeping_well/" + name));
        ModelFile.ExistingModelFile topModel = provider.models().getExistingFile(MalumMod.malumPath("block/" + name + "_top"));
        provider.getVariantBuilder(block).forAllStates(arg_0 -> MalumBlockStateSmithTypes.lambda$static$18((ModelFile)topModel, (ModelFile)model, arg_0));
    });
    public static BlockStateSmith<LargeStrangeCrystalBlock> LARGE_STRANGE_CRYSTAL = new BlockStateSmith(LargeStrangeCrystalBlock.class, ItemModelSmithTypes.GENERATED_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        provider.getVariantBuilder(block).forAllStates(state -> {
            ResourceLocation upper = provider.getBlockTexture(name + "_upper");
            ResourceLocation lower = provider.getBlockTexture(name + "_lower");
            DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(LargeStrangeCrystalBlock.HALF);
            boolean isTop = half.equals((Object)DoubleBlockHalf.UPPER);
            BlockModelBuilder model = (BlockModelBuilder)provider.models().cross(name + "_" + half.getSerializedName(), isTop ? upper : lower);
            return ConfiguredModel.builder().modelFile((ModelFile)model).build();
        });
    });
    public static BlockStateSmith<CreepingBlightBlock> CREEPING_BLIGHT = new BlockStateSmith(CreepingBlightBlock.class, ItemModelSmithTypes.GENERATED_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        ResourceLocation roots = MalumMod.malumPath("block/templates/blight/template_soulwood_roots");
        ResourceLocation spike = MalumMod.malumPath("block/templates/blight/template_soulwood_spike");
        ResourceLocation clinging = MalumMod.malumPath("block/templates/blight/template_clinging_blight");
        ResourceLocation hanging = MalumMod.malumPath("block/templates/blight/template_hanging_blight");
        provider.getVariantBuilder(block).forAllStates(s -> {
            CreepingBlightBlock.BlightType value = (CreepingBlightBlock.BlightType)((Object)((Object)((Object)s.getValue(CreepingBlightBlock.BLIGHT_TYPE))));
            String valueName = value.getSerializedName();
            ResourceLocation parent = switch (value) {
                default -> throw new MatchException(null, null);
                case CreepingBlightBlock.BlightType.SOULWOOD_ROOTS -> roots;
                case CreepingBlightBlock.BlightType.SOULWOOD_SPIKE -> spike;
                case CreepingBlightBlock.BlightType.CLINGING_BLIGHT -> clinging;
                case CreepingBlightBlock.BlightType.HANGING_BLIGHT -> hanging;
            };
            ResourceLocation large = provider.getBlockTexture(valueName + "_large");
            ResourceLocation largeExtension = provider.getBlockTexture(valueName + "_large_extension");
            ResourceLocation side = provider.getBlockTexture(valueName + "_small");
            BlockModelBuilder model = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_" + valueName, parent)).texture("large", large)).texture("large_extension", largeExtension)).texture("small", side)).texture("particle", large);
            if (parent.equals((Object)roots)) {
                ResourceLocation small_extension = provider.getBlockTexture(valueName + "_small_extension");
                model.texture("small_extension", small_extension);
            } else {
                ResourceLocation bracingTexture = provider.getBlockTexture(valueName + "_bracing");
                model.texture("bracing", bracingTexture);
            }
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(((int)((Direction)s.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build();
        });
    });
    public static BlockStateSmith<Block> BLIGHTED_GROWTH = new BlockStateSmith(Block.class, ItemModelSmithTypes.NO_DATAGEN, (block, provider) -> {
        String name = provider.getBlockName(block);
        Function<Integer, ModelFile> tumorFunction = i -> ((BlockModelBuilder)provider.models().withExistingParent(name + "_" + i, ResourceLocation.withDefaultNamespace((String)"block/cross"))).texture("cross", MalumMod.malumPath("block/" + name + "_" + i));
        ConfiguredModel.Builder builder = provider.getVariantBuilder(block).partialState().modelForState();
        for (int i2 = 0; i2 < 10; ++i2) {
            builder = builder.modelFile(tumorFunction.apply(i2));
            if (i2 == 9) continue;
            builder = builder.nextModel();
        }
        builder.addModel();
    });
    public static BlockStateSmith<EtherBrazierBlock> BRAZIER_BLOCK = new BlockStateSmith(EtherBrazierBlock.class, MalumItemModelSmithTypes.ETHER_BRAZIER_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replaceFirst("_iridescent", "");
        String particleName = textureName.replaceFirst("_ether_brazier", "") + "_rock";
        ModelBuilder brazier = ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name, MalumMod.malumPath("block/templates/template_ether_brazier"))).texture("brazier", provider.getBlockTexture(textureName))).texture("particle", provider.getBlockTexture(particleName));
        ModelBuilder brazier_hanging = ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_hanging", MalumMod.malumPath("block/templates/template_ether_brazier_hanging"))).texture("brazier", provider.getBlockTexture(textureName))).texture("particle", provider.getBlockTexture(particleName));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)provider.getVariantBuilder(block).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier_hanging).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)brazier_hanging).rotationY(90).addModel();
    });
    public static BlockStateSmith<EtherBrazierBlock> IRIDESCENT_BRAZIER_BLOCK = new BlockStateSmith(EtherBrazierBlock.class, MalumItemModelSmithTypes.IRIDESCENT_ETHER_BRAZIER_ITEM, (block, provider) -> {
        String name = provider.getBlockName(block);
        String textureName = name.replaceFirst("_iridescent", "");
        String particleName = textureName.replaceFirst("_ether_brazier", "") + "_rock";
        ModelBuilder brazier = ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name, MalumMod.malumPath("block/templates/template_ether_brazier"))).texture("brazier", provider.getBlockTexture(textureName))).texture("particle", provider.getBlockTexture(particleName));
        ModelBuilder brazier_hanging = ((BlockModelBuilder)((BlockModelBuilder)provider.models().withExistingParent(name + "_hanging", MalumMod.malumPath("block/templates/template_ether_brazier_hanging"))).texture("brazier", provider.getBlockTexture(textureName))).texture("particle", provider.getBlockTexture(particleName));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)provider.getVariantBuilder(block).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier_hanging).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)brazier_hanging).rotationY(90).addModel();
    });

    private static /* synthetic */ ConfiguredModel[] lambda$static$18(ModelFile topModel, ModelFile model, BlockState s) {
        return ConfiguredModel.builder().modelFile((Boolean)s.getValue((Property)PrimordialSoupBlock.TOP) != false ? topModel : model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$static$16(ModelFile model, BlockState state) {
        Direction dir = (Direction)state.getValue((Property)BlockStateProperties.FACING);
        return ConfiguredModel.builder().modelFile(model).rotationX(dir == Direction.DOWN ? 180 : (dir.getAxis().isHorizontal() ? 90 : 0)).rotationY(dir.getAxis().isVertical() ? 0 : (int)dir.toYRot() % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$static$12(ModelFile model, BlockState s) {
        return ConfiguredModel.builder().modelFile(model).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$static$10(ModelFile topModel, ModelFile model, BlockState s) {
        return ConfiguredModel.builder().modelFile((Boolean)s.getValue((Property)RepairPylonComponentBlock.TOP) != false ? topModel : model).build();
    }
}

