/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.block;

import com.sammy.malum.MalumMod;
import com.sammy.malum.common.block.curiosities.banner.SoulwovenBannerBlock;
import com.sammy.malum.datagen.block.MalumBlockStateSmithTypes;
import com.sammy.malum.datagen.item.MalumItemModelSmithTypes;
import com.sammy.malum.registry.common.block.MalumBlocks;
import java.util.HashSet;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import team.lodestar.lodestone.helpers.DataHelper;
import team.lodestar.lodestone.systems.datagen.BlockStateSmithTypes;
import team.lodestar.lodestone.systems.datagen.ItemModelSmithTypes;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneBlockModelProvider;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneBlockStateProvider;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneItemModelProvider;
import team.lodestar.lodestone.systems.datagen.statesmith.AbstractBlockStateSmith;

public class MalumBlockStates
extends LodestoneBlockStateProvider {
    public MalumBlockStates(PackOutput output, ExistingFileHelper exFileHelper, LodestoneItemModelProvider itemModelProvider) {
        super(output, "malum", exFileHelper, itemModelProvider);
    }

    @Nonnull
    public String getName() {
        return "Malum BlockStates";
    }

    protected void registerStatesAndModels() {
        HashSet blocks = new HashSet(MalumBlocks.BLOCKS.getEntries());
        AbstractBlockStateSmith.StateSmithData data = new AbstractBlockStateSmith.StateSmithData((LodestoneBlockStateProvider)this, blocks::remove);
        this.setTexturePath("banners/");
        MalumBlockStateSmithTypes.SOULWOVEN_BANNER.act(data, DataHelper.takeAll(blocks, b -> b.get() instanceof SoulwovenBannerBlock));
        this.setTexturePath("spirited_glass/");
        BlockStateSmithTypes.FULL_BLOCK.act(data, new Supplier[]{MalumBlocks.SACRED_SPIRITED_GLASS, MalumBlocks.WICKED_SPIRITED_GLASS, MalumBlocks.ARCANE_SPIRITED_GLASS, MalumBlocks.ELDRITCH_SPIRITED_GLASS, MalumBlocks.AERIAL_SPIRITED_GLASS, MalumBlocks.AQUEOUS_SPIRITED_GLASS, MalumBlocks.INFERNAL_SPIRITED_GLASS, MalumBlocks.EARTHEN_SPIRITED_GLASS});
        this.setTexturePath("arcane_rock/tainted/");
        BlockStateSmithTypes.FULL_BLOCK.act(data, new Supplier[]{MalumBlocks.TAINTED_ROCK, MalumBlocks.POLISHED_TAINTED_ROCK, MalumBlocks.SMOOTH_TAINTED_ROCK, MalumBlocks.TAINTED_ROCK_BRICKS, MalumBlocks.TAINTED_ROCK_TILES, MalumBlocks.SMALL_TAINTED_ROCK_BRICKS, MalumBlocks.RUNIC_TAINTED_ROCK_BRICKS, MalumBlocks.RUNIC_TAINTED_ROCK_TILES, MalumBlocks.RUNIC_SMALL_TAINTED_ROCK_BRICKS, MalumBlocks.CHISELED_TAINTED_ROCK});
        BlockStateSmithTypes.SLAB_BLOCK.act(data, new Supplier[]{MalumBlocks.TAINTED_ROCK_SLAB, MalumBlocks.POLISHED_TAINTED_ROCK_SLAB, MalumBlocks.SMOOTH_TAINTED_ROCK_SLAB, MalumBlocks.TAINTED_ROCK_BRICKS_SLAB, MalumBlocks.TAINTED_ROCK_TILES_SLAB, MalumBlocks.SMALL_TAINTED_ROCK_BRICKS_SLAB, MalumBlocks.RUNIC_TAINTED_ROCK_BRICKS_SLAB, MalumBlocks.RUNIC_TAINTED_ROCK_TILES_SLAB, MalumBlocks.RUNIC_SMALL_TAINTED_ROCK_BRICKS_SLAB});
        BlockStateSmithTypes.STAIRS_BLOCK.act(data, new Supplier[]{MalumBlocks.TAINTED_ROCK_STAIRS, MalumBlocks.POLISHED_TAINTED_ROCK_STAIRS, MalumBlocks.SMOOTH_TAINTED_ROCK_STAIRS, MalumBlocks.TAINTED_ROCK_BRICKS_STAIRS, MalumBlocks.TAINTED_ROCK_TILES_STAIRS, MalumBlocks.SMALL_TAINTED_ROCK_BRICKS_STAIRS, MalumBlocks.RUNIC_TAINTED_ROCK_BRICKS_STAIRS, MalumBlocks.RUNIC_TAINTED_ROCK_TILES_STAIRS, MalumBlocks.RUNIC_SMALL_TAINTED_ROCK_BRICKS_STAIRS});
        BlockStateSmithTypes.WALL_BLOCK.act(data, new Supplier[]{MalumBlocks.TAINTED_ROCK_WALL, MalumBlocks.SMOOTH_TAINTED_ROCK_WALL, MalumBlocks.POLISHED_TAINTED_ROCK_WALL, MalumBlocks.TAINTED_ROCK_BRICKS_WALL, MalumBlocks.TAINTED_ROCK_TILES_WALL, MalumBlocks.SMALL_TAINTED_ROCK_BRICKS_WALL, MalumBlocks.RUNIC_TAINTED_ROCK_BRICKS_WALL, MalumBlocks.RUNIC_TAINTED_ROCK_TILES_WALL, MalumBlocks.RUNIC_SMALL_TAINTED_ROCK_BRICKS_WALL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::cutRockBlockModel, new Supplier[]{MalumBlocks.CUT_TAINTED_ROCK, MalumBlocks.CHECKERED_TAINTED_ROCK});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).directionalBlock(arg_0, arg_1), this::columnCapModel, new Supplier[]{MalumBlocks.TAINTED_ROCK_COLUMN_CAP});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::rockItemPedestalModel, new Supplier[]{MalumBlocks.TAINTED_ROCK_ITEM_PEDESTAL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).directionalBlock(arg_0, arg_1), this::itemStandModel, new Supplier[]{MalumBlocks.TAINTED_ROCK_ITEM_STAND});
        BlockStateSmithTypes.LOG_BLOCK.act(data, new Supplier[]{MalumBlocks.TAINTED_ROCK_COLUMN});
        BlockStateSmithTypes.BUTTON_BLOCK.act(data, new Supplier[]{MalumBlocks.TAINTED_ROCK_BUTTON});
        BlockStateSmithTypes.PRESSURE_PLATE_BLOCK.act(data, new Supplier[]{MalumBlocks.TAINTED_ROCK_PRESSURE_PLATE});
        this.itemModelProvider.setTexturePath("ether/");
        MalumBlockStateSmithTypes.BRAZIER_BLOCK.act(data, new Supplier[]{MalumBlocks.TAINTED_ETHER_BRAZIER});
        MalumBlockStateSmithTypes.IRIDESCENT_BRAZIER_BLOCK.act(data, new Supplier[]{MalumBlocks.TAINTED_IRIDESCENT_ETHER_BRAZIER});
        this.itemModelProvider.setTexturePath("");
        this.setTexturePath("arcane_rock/twisted/");
        BlockStateSmithTypes.FULL_BLOCK.act(data, new Supplier[]{MalumBlocks.TWISTED_ROCK, MalumBlocks.POLISHED_TWISTED_ROCK, MalumBlocks.SMOOTH_TWISTED_ROCK, MalumBlocks.TWISTED_ROCK_BRICKS, MalumBlocks.TWISTED_ROCK_TILES, MalumBlocks.SMALL_TWISTED_ROCK_BRICKS, MalumBlocks.RUNIC_TWISTED_ROCK_BRICKS, MalumBlocks.RUNIC_TWISTED_ROCK_TILES, MalumBlocks.RUNIC_SMALL_TWISTED_ROCK_BRICKS, MalumBlocks.CHISELED_TWISTED_ROCK});
        BlockStateSmithTypes.SLAB_BLOCK.act(data, new Supplier[]{MalumBlocks.TWISTED_ROCK_SLAB, MalumBlocks.POLISHED_TWISTED_ROCK_SLAB, MalumBlocks.SMOOTH_TWISTED_ROCK_SLAB, MalumBlocks.TWISTED_ROCK_BRICKS_SLAB, MalumBlocks.TWISTED_ROCK_TILES_SLAB, MalumBlocks.SMALL_TWISTED_ROCK_BRICKS_SLAB, MalumBlocks.RUNIC_TWISTED_ROCK_BRICKS_SLAB, MalumBlocks.RUNIC_TWISTED_ROCK_TILES_SLAB, MalumBlocks.RUNIC_SMALL_TWISTED_ROCK_BRICKS_SLAB});
        BlockStateSmithTypes.STAIRS_BLOCK.act(data, new Supplier[]{MalumBlocks.TWISTED_ROCK_STAIRS, MalumBlocks.POLISHED_TWISTED_ROCK_STAIRS, MalumBlocks.SMOOTH_TWISTED_ROCK_STAIRS, MalumBlocks.TWISTED_ROCK_BRICKS_STAIRS, MalumBlocks.TWISTED_ROCK_TILES_STAIRS, MalumBlocks.SMALL_TWISTED_ROCK_BRICKS_STAIRS, MalumBlocks.RUNIC_TWISTED_ROCK_BRICKS_STAIRS, MalumBlocks.RUNIC_TWISTED_ROCK_TILES_STAIRS, MalumBlocks.RUNIC_SMALL_TWISTED_ROCK_BRICKS_STAIRS});
        BlockStateSmithTypes.WALL_BLOCK.act(data, new Supplier[]{MalumBlocks.TWISTED_ROCK_WALL, MalumBlocks.SMOOTH_TWISTED_ROCK_WALL, MalumBlocks.POLISHED_TWISTED_ROCK_WALL, MalumBlocks.TWISTED_ROCK_BRICKS_WALL, MalumBlocks.TWISTED_ROCK_TILES_WALL, MalumBlocks.SMALL_TWISTED_ROCK_BRICKS_WALL, MalumBlocks.RUNIC_TWISTED_ROCK_BRICKS_WALL, MalumBlocks.RUNIC_TWISTED_ROCK_TILES_WALL, MalumBlocks.RUNIC_SMALL_TWISTED_ROCK_BRICKS_WALL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::cutRockBlockModel, new Supplier[]{MalumBlocks.CUT_TWISTED_ROCK, MalumBlocks.CHECKERED_TWISTED_ROCK});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).directionalBlock(arg_0, arg_1), this::columnCapModel, new Supplier[]{MalumBlocks.TWISTED_ROCK_COLUMN_CAP});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::rockItemPedestalModel, new Supplier[]{MalumBlocks.TWISTED_ROCK_ITEM_PEDESTAL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).directionalBlock(arg_0, arg_1), this::itemStandModel, new Supplier[]{MalumBlocks.TWISTED_ROCK_ITEM_STAND});
        BlockStateSmithTypes.LOG_BLOCK.act(data, new Supplier[]{MalumBlocks.TWISTED_ROCK_COLUMN});
        BlockStateSmithTypes.BUTTON_BLOCK.act(data, new Supplier[]{MalumBlocks.TWISTED_ROCK_BUTTON});
        BlockStateSmithTypes.PRESSURE_PLATE_BLOCK.act(data, new Supplier[]{MalumBlocks.TWISTED_ROCK_PRESSURE_PLATE});
        this.itemModelProvider.setTexturePath("ether/");
        MalumBlockStateSmithTypes.BRAZIER_BLOCK.act(data, new Supplier[]{MalumBlocks.TWISTED_ETHER_BRAZIER});
        MalumBlockStateSmithTypes.IRIDESCENT_BRAZIER_BLOCK.act(data, new Supplier[]{MalumBlocks.TWISTED_IRIDESCENT_ETHER_BRAZIER});
        this.itemModelProvider.setTexturePath("");
        this.setTexturePath("runewood/");
        BlockStateSmithTypes.FULL_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_BOARDS, MalumBlocks.VERTICAL_RUNEWOOD_BOARDS, MalumBlocks.RUNEWOOD_PLANKS, MalumBlocks.VERTICAL_RUNEWOOD_PLANKS, MalumBlocks.RUNEWOOD_TILES, MalumBlocks.RUSTIC_RUNEWOOD_PLANKS, MalumBlocks.VERTICAL_RUSTIC_RUNEWOOD_PLANKS, MalumBlocks.RUSTIC_RUNEWOOD_TILES, MalumBlocks.RUNEWOOD_PANEL});
        BlockStateSmithTypes.SLAB_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_BOARDS_SLAB, MalumBlocks.VERTICAL_RUNEWOOD_BOARDS_SLAB, MalumBlocks.RUNEWOOD_PLANKS_SLAB, MalumBlocks.VERTICAL_RUNEWOOD_PLANKS_SLAB, MalumBlocks.RUNEWOOD_TILES_SLAB, MalumBlocks.RUSTIC_RUNEWOOD_PLANKS_SLAB, MalumBlocks.VERTICAL_RUSTIC_RUNEWOOD_PLANKS_SLAB, MalumBlocks.RUSTIC_RUNEWOOD_TILES_SLAB});
        BlockStateSmithTypes.STAIRS_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_BOARDS_STAIRS, MalumBlocks.VERTICAL_RUNEWOOD_BOARDS_STAIRS, MalumBlocks.RUNEWOOD_PLANKS_STAIRS, MalumBlocks.VERTICAL_RUNEWOOD_PLANKS_STAIRS, MalumBlocks.RUNEWOOD_TILES_STAIRS, MalumBlocks.RUSTIC_RUNEWOOD_PLANKS_STAIRS, MalumBlocks.VERTICAL_RUSTIC_RUNEWOOD_PLANKS_STAIRS, MalumBlocks.RUSTIC_RUNEWOOD_TILES_STAIRS});
        BlockStateSmithTypes.LOG_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_BEAM, MalumBlocks.RUNEWOOD_LOG, MalumBlocks.STRIPPED_RUNEWOOD_LOG, MalumBlocks.EXPOSED_RUNEWOOD_LOG, MalumBlocks.REVEALED_RUNEWOOD_LOG});
        BlockStateSmithTypes.WOOD_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD, MalumBlocks.STRIPPED_RUNEWOOD});
        BlockStateSmithTypes.LEAVES_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_LEAVES, MalumBlocks.AZURE_RUNEWOOD_LEAVES});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_TEXTURE_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::hangingLeavesModel, new Supplier[]{MalumBlocks.HANGING_RUNEWOOD_LEAVES, MalumBlocks.HANGING_AZURE_RUNEWOOD_LEAVES});
        MalumBlockStateSmithTypes.POTTED_PLANT.act(data, new Supplier[]{MalumBlocks.POTTED_RUNEWOOD_SAPLING, MalumBlocks.POTTED_AZURE_RUNEWOOD_SAPLING});
        BlockStateSmithTypes.CROSS_MODEL_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_SAPLING, MalumBlocks.AZURE_RUNEWOOD_SAPLING});
        BlockStateSmithTypes.BUTTON_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_BUTTON});
        BlockStateSmithTypes.PRESSURE_PLATE_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_PRESSURE_PLATE});
        BlockStateSmithTypes.DOOR_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_DOOR, MalumBlocks.BOLTED_RUNEWOOD_DOOR, MalumBlocks.RUNEWOOD_BOARDS_DOOR, MalumBlocks.BOLTED_RUNEWOOD_BOARDS_DOOR});
        BlockStateSmithTypes.TRAPDOOR_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_TRAPDOOR, MalumBlocks.BOLTED_RUNEWOOD_TRAPDOOR, MalumBlocks.RUNEWOOD_BOARDS_TRAPDOOR, MalumBlocks.BOLTED_RUNEWOOD_BOARDS_TRAPDOOR});
        BlockStateSmithTypes.WOODEN_SIGN_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_SIGN, MalumBlocks.RUNEWOOD_WALL_SIGN});
        BlockStateSmithTypes.FENCE_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_FENCE});
        BlockStateSmithTypes.FENCE_GATE_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_FENCE_GATE});
        BlockStateSmithTypes.WALL_BLOCK.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_BOARDS_WALL});
        MalumBlockStateSmithTypes.TOTEM_POLE.act(data, new Supplier[]{MalumBlocks.RUNEWOOD_TOTEM_POLE});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::totemBaseModel, new Supplier[]{MalumBlocks.RUNEWOOD_TOTEM_BASE});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::cutWoodBlockModel, new Supplier[]{MalumBlocks.CUT_RUNEWOOD_PLANKS});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::woodenItemPedestalModel, new Supplier[]{MalumBlocks.RUNEWOOD_ITEM_PEDESTAL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::decoratedItemPedestalModel, new Supplier[]{MalumBlocks.GILDED_RUNEWOOD_ITEM_PEDESTAL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).directionalBlock(arg_0, arg_1), this::itemStandModel, new Supplier[]{MalumBlocks.RUNEWOOD_ITEM_STAND});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).directionalBlock(arg_0, arg_1), this::decoratedItemStandModel, new Supplier[]{MalumBlocks.GILDED_RUNEWOOD_ITEM_STAND});
        this.setTexturePath("soulwood/");
        BlockStateSmithTypes.FULL_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_BOARDS, MalumBlocks.VERTICAL_SOULWOOD_BOARDS, MalumBlocks.SOULWOOD_PLANKS, MalumBlocks.VERTICAL_SOULWOOD_PLANKS, MalumBlocks.SOULWOOD_TILES, MalumBlocks.RUSTIC_SOULWOOD_PLANKS, MalumBlocks.VERTICAL_RUSTIC_SOULWOOD_PLANKS, MalumBlocks.RUSTIC_SOULWOOD_TILES, MalumBlocks.SOULWOOD_PANEL});
        BlockStateSmithTypes.SLAB_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_BOARDS_SLAB, MalumBlocks.VERTICAL_SOULWOOD_BOARDS_SLAB, MalumBlocks.SOULWOOD_PLANKS_SLAB, MalumBlocks.VERTICAL_SOULWOOD_PLANKS_SLAB, MalumBlocks.SOULWOOD_TILES_SLAB, MalumBlocks.RUSTIC_SOULWOOD_PLANKS_SLAB, MalumBlocks.VERTICAL_RUSTIC_SOULWOOD_PLANKS_SLAB, MalumBlocks.RUSTIC_SOULWOOD_TILES_SLAB});
        BlockStateSmithTypes.STAIRS_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_BOARDS_STAIRS, MalumBlocks.VERTICAL_SOULWOOD_BOARDS_STAIRS, MalumBlocks.SOULWOOD_PLANKS_STAIRS, MalumBlocks.VERTICAL_SOULWOOD_PLANKS_STAIRS, MalumBlocks.SOULWOOD_TILES_STAIRS, MalumBlocks.RUSTIC_SOULWOOD_PLANKS_STAIRS, MalumBlocks.VERTICAL_RUSTIC_SOULWOOD_PLANKS_STAIRS, MalumBlocks.RUSTIC_SOULWOOD_TILES_STAIRS});
        BlockStateSmithTypes.LOG_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_BEAM, MalumBlocks.SOULWOOD_LOG, MalumBlocks.STRIPPED_SOULWOOD_LOG, MalumBlocks.EXPOSED_SOULWOOD_LOG, MalumBlocks.REVEALED_SOULWOOD_LOG});
        BlockStateSmithTypes.WOOD_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD, MalumBlocks.STRIPPED_SOULWOOD});
        BlockStateSmithTypes.LEAVES_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_LEAVES});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_TEXTURE_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::hangingLeavesModel, new Supplier[]{MalumBlocks.HANGING_SOULWOOD_LEAVES});
        MalumBlockStateSmithTypes.POTTED_PLANT.act(data, new Supplier[]{MalumBlocks.POTTED_SOULWOOD_SAPLING});
        BlockStateSmithTypes.CROSS_MODEL_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_SAPLING});
        BlockStateSmithTypes.BUTTON_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_BUTTON});
        BlockStateSmithTypes.PRESSURE_PLATE_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_PRESSURE_PLATE});
        BlockStateSmithTypes.DOOR_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_DOOR, MalumBlocks.BOLTED_SOULWOOD_DOOR, MalumBlocks.SOULWOOD_BOARDS_DOOR, MalumBlocks.BOLTED_SOULWOOD_BOARDS_DOOR});
        BlockStateSmithTypes.TRAPDOOR_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_TRAPDOOR, MalumBlocks.BOLTED_SOULWOOD_TRAPDOOR, MalumBlocks.SOULWOOD_BOARDS_TRAPDOOR, MalumBlocks.BOLTED_SOULWOOD_BOARDS_TRAPDOOR});
        BlockStateSmithTypes.WOODEN_SIGN_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_SIGN, MalumBlocks.SOULWOOD_WALL_SIGN});
        BlockStateSmithTypes.FENCE_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_FENCE});
        BlockStateSmithTypes.FENCE_GATE_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_FENCE_GATE});
        BlockStateSmithTypes.WALL_BLOCK.act(data, new Supplier[]{MalumBlocks.SOULWOOD_BOARDS_WALL});
        MalumBlockStateSmithTypes.TOTEM_POLE.act(data, new Supplier[]{MalumBlocks.SOULWOOD_TOTEM_POLE});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::totemBaseModel, new Supplier[]{MalumBlocks.SOULWOOD_TOTEM_BASE});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::cutWoodBlockModel, new Supplier[]{MalumBlocks.CUT_SOULWOOD_PLANKS});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::woodenItemPedestalModel, new Supplier[]{MalumBlocks.SOULWOOD_ITEM_PEDESTAL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::decoratedItemPedestalModel, new Supplier[]{MalumBlocks.ORNATE_SOULWOOD_ITEM_PEDESTAL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).directionalBlock(arg_0, arg_1), this::itemStandModel, new Supplier[]{MalumBlocks.SOULWOOD_ITEM_STAND});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).directionalBlock(arg_0, arg_1), this::decoratedItemStandModel, new Supplier[]{MalumBlocks.ORNATE_SOULWOOD_ITEM_STAND});
        this.setTexturePath("ores/");
        BlockStateSmithTypes.FULL_BLOCK.act(data, new Supplier[]{MalumBlocks.CTHONIC_GOLD_ORE, MalumBlocks.NATURAL_QUARTZ_ORE, MalumBlocks.DEEPSLATE_QUARTZ_ORE, MalumBlocks.SOULSTONE_ORE, MalumBlocks.DEEPSLATE_SOULSTONE_ORE});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::layeredBlockModel, new Supplier[]{MalumBlocks.BLAZING_QUARTZ_ORE, MalumBlocks.BRILLIANT_STONE, MalumBlocks.BRILLIANT_DEEPSLATE});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.GENERATED_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).directionalBlock(arg_0, arg_1), this.fromFunction((arg_0, arg_1) -> ((LodestoneBlockModelProvider)this.models()).cross(arg_0, arg_1)), new Supplier[]{MalumBlocks.NATURAL_QUARTZ_CLUSTER, MalumBlocks.CTHONIC_GOLD_CLUSTER, MalumBlocks.BLAZING_QUARTZ_CLUSTER});
        this.setTexturePath("storage_blocks/");
        BlockStateSmithTypes.FULL_BLOCK.act(data, new Supplier[]{MalumBlocks.BLOCK_OF_RAW_SOULSTONE, MalumBlocks.BLOCK_OF_SOULSTONE, MalumBlocks.BLOCK_OF_CTHONIC_GOLD, MalumBlocks.BLOCK_OF_BRILLIANCE, MalumBlocks.BLOCK_OF_ROTTING_ESSENCE, MalumBlocks.BLOCK_OF_GRIM_TALC, MalumBlocks.BLOCK_OF_ASTRAL_WEAVE, MalumBlocks.BLOCK_OF_HEX_ASH, MalumBlocks.BLOCK_OF_ALCHEMICAL_CALX, MalumBlocks.MASS_OF_BLIGHTED_GUNK, MalumBlocks.BLOCK_OF_SOUL_STAINED_STEEL, MalumBlocks.BLOCK_OF_HALLOWED_GOLD, MalumBlocks.BLOCK_OF_MALIGNANT_PEWTER, MalumBlocks.BLOCK_OF_NULL_SLATE, MalumBlocks.BLOCK_OF_VOID_SALTS, MalumBlocks.BLOCK_OF_MNEMONIC_FRAGMENT, MalumBlocks.BLOCK_OF_MALIGNANT_LEAD, MalumBlocks.BLOCK_OF_BLAZING_QUARTZ, MalumBlocks.BLOCK_OF_ARCANE_CHARCOAL, MalumBlocks.BLOCK_OF_AURIC_EMBERS, MalumBlocks.BLOCK_OF_LIVING_FLESH});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::cubeBottomTop, new Supplier[]{MalumBlocks.BLOCK_OF_WARP_FLUX});
        this.setTexturePath("blight/");
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::cubeBottomTop, new Supplier[]{MalumBlocks.BLIGHTED_EARTH});
        MalumBlockStateSmithTypes.COVERING_BLOCK.act(data, new Supplier[]{MalumBlocks.BLIGHT});
        MalumBlockStateSmithTypes.BLIGHTED_GROWTH.act(data, new Supplier[]{MalumBlocks.BLIGHTED_GROWTH});
        MalumBlockStateSmithTypes.CREEPING_BLIGHT.act(data, new Supplier[]{MalumBlocks.CLINGING_BLIGHT});
        MalumBlockStateSmithTypes.POTTED_PLANT.act(data, new Supplier[]{MalumBlocks.POTTED_BLIGHTPEARL, MalumBlocks.POTTED_BLIGHTROOT});
        BlockStateSmithTypes.CROSS_MODEL_BLOCK.act(data, new Supplier[]{MalumBlocks.BLIGHTPEARL, MalumBlocks.BLIGHTROOT});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::blightedSoulwoodModel, new Supplier[]{MalumBlocks.BLIGHTED_SOULWOOD});
        this.setTexturePath("blight/scarstone/");
        MalumBlockStateSmithTypes.LARGE_STRANGE_CRYSTAL.act(data, new Supplier[]{MalumBlocks.LARGE_STRANGE_CRYSTAL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.GENERATED_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::crossModel, new Supplier[]{MalumBlocks.STRANGE_CRYSTAL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::cubeBottomTop, new Supplier[]{MalumBlocks.SCARSTONE});
        BlockStateSmithTypes.CROSS_MODEL_BLOCK.act(data, new Supplier[]{MalumBlocks.STRANGEROOT});
        MalumBlockStateSmithTypes.POTTED_PLANT.act(data, new Supplier[]{MalumBlocks.POTTED_STRANGEROOT});
        this.setTexturePath("spirit_diode/");
        MalumBlockStateSmithTypes.SPIRIT_DIODE.act(data, new Supplier[]{MalumBlocks.WAVECHARGER, MalumBlocks.WAVEBANKER, MalumBlocks.WAVEMAKER, MalumBlocks.WAVEBREAKER});
        this.setTexturePath("");
        this.itemModelProvider.setTexturePath("ether/");
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.GENERATED_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::etherModel, new Supplier[]{MalumBlocks.ETHER});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, MalumItemModelSmithTypes.GENERATED_OVERLAY_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::etherTorchModel, new Supplier[]{MalumBlocks.ETHER_TORCH});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.NO_DATAGEN, (b, m) -> this.horizontalBlock(b, m, 90), this::wallEtherTorchModel, new Supplier[]{MalumBlocks.WALL_ETHER_TORCH});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, MalumItemModelSmithTypes.GENERATED_OVERLAY_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::etherModel, new Supplier[]{MalumBlocks.IRIDESCENT_ETHER});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, MalumItemModelSmithTypes.IRIDESCENT_ETHER_TORCH_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::etherTorchModel, new Supplier[]{MalumBlocks.IRIDESCENT_ETHER_TORCH});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.NO_DATAGEN, (b, m) -> this.horizontalBlock(b, m, 90), this::wallEtherTorchModel, new Supplier[]{MalumBlocks.IRIDESCENT_WALL_ETHER_TORCH});
        this.itemModelProvider.setTexturePath("");
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), arg_0 -> ((MalumBlockStates)this).predefinedModel(arg_0), new Supplier[]{MalumBlocks.SPIRIT_ALTAR, MalumBlocks.SOUL_BRAZIER, MalumBlocks.RITUAL_PLINTH});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BUILTIN_ENTITY_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), arg_0 -> ((MalumBlockStates)this).predefinedModel(arg_0), new Supplier[]{MalumBlocks.SPIRIT_JAR});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).horizontalBlock(arg_0, arg_1), arg_0 -> ((MalumBlockStates)this).predefinedModel(arg_0), new Supplier[]{MalumBlocks.WEAVERS_WORKBENCH, MalumBlocks.RUNIC_WORKBENCH});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.NO_DATAGEN, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), arg_0 -> ((MalumBlockStates)this).predefinedModel(arg_0), new Supplier[]{MalumBlocks.RUNEWOOD_OBELISK, MalumBlocks.RUNEWOOD_OBELISK_COMPONENT, MalumBlocks.BRILLIANT_OBELISK, MalumBlocks.BRILLIANT_OBELISK_COMPONENT, MalumBlocks.SPIRIT_CRUCIBLE, MalumBlocks.SPIRIT_CRUCIBLE_COMPONENT, MalumBlocks.REPAIR_PYLON});
        MalumBlockStateSmithTypes.REPAIR_PYLON_COMPONENT.act(data, new Supplier[]{MalumBlocks.REPAIR_PYLON_COMPONENT});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.NO_DATAGEN, (arg_0, arg_1) -> ((MalumBlockStates)this).horizontalBlock(arg_0, arg_1), arg_0 -> ((MalumBlockStates)this).predefinedModel(arg_0), new Supplier[]{MalumBlocks.SPIRIT_CATALYZER, MalumBlocks.SPIRIT_CATALYZER_COMPONENT});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.BLOCK_MODEL_ITEM, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), arg_0 -> ((MalumBlockStates)this).predefinedModel(arg_0), new Supplier[]{MalumBlocks.VOID_CONDUIT, MalumBlocks.VOID_DEPOT});
        MalumBlockStateSmithTypes.WEEPING_WELL_LAYERED_BLOCK.act(data, new Supplier[]{MalumBlocks.WEEPING_WELL_CENTER, MalumBlocks.WEEPING_WELL_SIDE, MalumBlocks.WEEPING_WELL_SIDE_MIRROR, MalumBlocks.WEEPING_WELL_CORNER});
        MalumBlockStateSmithTypes.WEEPING_WELL_BLOCK.act(data, new Supplier[]{MalumBlocks.WEEPING_WELL_FLAGSTONE});
        MalumBlockStateSmithTypes.WEEPING_WELL_DIRECTIONAL_BLOCK.act(data, new Supplier[]{MalumBlocks.WEEPING_WELL_COLUMN_BASE, MalumBlocks.WEEPING_WELL_COLUMN, MalumBlocks.WEEPING_WELL_COLUMN_CAP});
        MalumBlockStateSmithTypes.PRIMORDIAL_SOUP.act(data, new Supplier[]{MalumBlocks.PRIMORDIAL_SOUP});
        BlockStateSmithTypes.FULL_BLOCK.act(data, new Supplier[]{MalumBlocks.THE_DEVICE, MalumBlocks.THE_VESSEL});
        BlockStateSmithTypes.CUSTOM_MODEL.act(data, ItemModelSmithTypes.NO_DATAGEN, (arg_0, arg_1) -> ((MalumBlockStates)this).simpleBlock(arg_0, arg_1), this::cubeModelAirTexture, new Supplier[]{MalumBlocks.SPIRIT_MOTE});
    }

    public ModelFile cubeModelAirTexture(Block block) {
        String name = this.getBlockName(block);
        return ((BlockModelBuilder)this.models().cubeAll(name, MalumMod.malumPath("block/air"))).texture("particle", this.getBlockTexture(name));
    }

    public ModelFile columnCapModel(Block block) {
        String name = this.getBlockName(block);
        ResourceLocation top = this.getBlockTexture(name + "_top");
        ResourceLocation bottom = this.getBlockTexture(name.replace("_cap", "") + "_top");
        ResourceLocation side = this.getBlockTexture(name);
        return this.models().cubeBottomTop(name, side, bottom, top);
    }

    public ModelFile directionalRedstoneMachineBlock(Block block) {
        String name = this.getBlockName(block);
        ResourceLocation top = this.getBlockTexture("runewood_frame_top");
        ResourceLocation bottom = this.getBlockTexture("runewood_frame_bottom");
        ResourceLocation locked = this.getBlockTexture("runewood_frame_locked");
        ResourceLocation input = this.getBlockTexture("runewood_frame_input");
        ResourceLocation output = this.getBlockTexture(name + "_output");
        return ((BlockModelBuilder)this.models().cube(name, bottom, top, output, input, locked, locked)).texture("particle", locked);
    }

    public ModelFile cutRockBlockModel(Block block) {
        String name = this.getBlockName(block);
        int index = name.indexOf("_");
        String substring = name.substring(index + 1);
        ResourceLocation top = this.getBlockTexture("polished_" + substring);
        ResourceLocation bottom = this.getBlockTexture("smooth_" + substring);
        ResourceLocation side = this.getBlockTexture(name);
        return this.models().cubeBottomTop(name, side, bottom, top);
    }

    public ModelFile cutWoodBlockModel(Block block) {
        String name = this.getBlockName(block);
        ResourceLocation top = this.getBlockTexture(name.replace("cut_", ""));
        ResourceLocation side = this.getBlockTexture(name);
        return this.models().cubeBottomTop(name, side, top, top);
    }

    public ModelFile rockItemPedestalModel(Block block) {
        return this.itemPedestalModel(block, "template_item_pedestal_rock");
    }

    public ModelFile woodenItemPedestalModel(Block block) {
        return this.itemPedestalModel(block, "template_item_pedestal_wooden");
    }

    public ModelFile decoratedItemPedestalModel(Block block) {
        return this.itemPedestalModel(block, "template_item_pedestal_wooden_decorated", s -> s.substring(s.indexOf("_") + 1) + "_" + s.split("_")[0]);
    }

    public ModelFile itemPedestalModel(Block block, String template) {
        return this.itemPedestalModel(block, template, s -> s);
    }

    public ModelFile itemPedestalModel(Block block, String template, Function<String, String> pathFunction) {
        String name = this.getBlockName(block);
        ResourceLocation parent = MalumMod.malumPath("block/templates/" + template);
        ResourceLocation pedestal = this.getBlockTexture(pathFunction.apply(name));
        return ((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture("pedestal", pedestal);
    }

    public ModelFile itemStandModel(Block block) {
        return this.itemStandModel(block, "template_item_stand", s -> s);
    }

    public ModelFile decoratedItemStandModel(Block block) {
        return this.itemStandModel(block, "template_item_stand_decorated", s -> s.substring(s.indexOf("_") + 1) + "_" + s.split("_")[0]);
    }

    public ModelFile itemStandModel(Block block, String template, Function<String, String> pathFunction) {
        String name = this.getBlockName(block);
        ResourceLocation parent = MalumMod.malumPath("block/templates/" + template);
        ResourceLocation stand = this.getBlockTexture(pathFunction.apply(name));
        return ((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture("stand", stand);
    }

    public ModelFile layeredBlockModel(Block block) {
        String name = this.getBlockName(block);
        ResourceLocation parent = MalumMod.malumPath("block/templates/template_glowing_block");
        ResourceLocation texture = this.getBlockTexture(name);
        ResourceLocation glowingTexture = this.getBlockTexture(name + "_glow");
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, parent)).texture("all", texture)).texture("glow", glowingTexture)).texture("particle", texture);
    }

    public ModelFile etherModel(Block block) {
        String name = this.getBlockName(block);
        return ((BlockModelBuilder)this.models().withExistingParent(name, ResourceLocation.withDefaultNamespace((String)"block/air"))).texture("particle", this.itemModelProvider.getItemTexture("ether"));
    }

    public ModelFile etherTorchModel(Block block) {
        return this.models().getExistingFile(MalumMod.malumPath("block/ether_torch"));
    }

    public ModelFile wallEtherTorchModel(Block block) {
        return this.models().getExistingFile(MalumMod.malumPath("block/ether_torch_wall"));
    }

    public ModelFile totemBaseModel(Block block) {
        String name = this.getBlockName(block);
        String woodName = name.substring(0, 8);
        ResourceLocation side = this.getBlockTexture(woodName + "_log");
        ResourceLocation top = this.getBlockTexture(woodName + "_log_top");
        ResourceLocation planks = this.getBlockTexture(woodName + "_planks");
        ResourceLocation panel = this.getBlockTexture(woodName + "_panel");
        return ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumMod.malumPath("block/templates/template_totem_base"))).texture("side", side)).texture("top", top)).texture("planks", planks)).texture("panel", panel);
    }

    public ModelFile hangingLeavesModel(Block block) {
        String name = this.getBlockName(block);
        ResourceLocation texture = this.getBlockTexture(name);
        return ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumMod.malumPath("block/templates/template_hanging_leaves"))).texture("hanging_leaves", texture)).texture("particle", texture);
    }

    public ModelFile blightedSoulwoodModel(Block block) {
        String name = this.getBlockName(block);
        ResourceLocation side = this.getBlockTexture(name);
        ResourceLocation bottom = this.getBlockTexture("blighted_earth_bottom");
        ResourceLocation top = this.getStaticBlockTexture("soulwood/soulwood_log_top");
        return this.models().cubeBottomTop(name, side, bottom, top);
    }

    public ModelFile cubeBottomTop(Block block) {
        String name = this.getBlockName(block);
        ResourceLocation side = this.getBlockTexture(name + "_side");
        ResourceLocation bottom = this.getBlockTexture(name + "_bottom");
        ResourceLocation top = this.getBlockTexture(name);
        return this.models().cubeBottomTop(name, side, bottom, top);
    }

    public ModelFile crossModel(Block block) {
        String name = this.getBlockName(block);
        return this.models().cross(name, this.getBlockTexture(name));
    }
}

