/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.recipe.builder.vanilla;

import com.sammy.malum.common.recipe.node_cooking.MetalNodeBlastingRecipe;
import com.sammy.malum.common.recipe.node_cooking.MetalNodeSmeltingRecipe;
import com.sammy.malum.common.recipe.node_cooking.NodeCookingSerializer;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Criterion;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import team.lodestar.lodestone.recipe.builder.LodestoneRecipeBuilder;

public class MetalNodeCookingRecipeBuilder<T extends AbstractCookingRecipe>
implements LodestoneRecipeBuilder<T> {
    public final RecipeCategory category;
    public final CookingBookCategory bookCategory;
    public final Ingredient ingredient;
    public final Ingredient result;
    public final int outputCount;
    public final float experience;
    public final int cookingTime;
    public Map<String, Criterion<?>> criteria = new LinkedHashMap();
    @Nullable
    public String group;
    public final NodeCookingSerializer.Factory<T> factory;

    protected MetalNodeCookingRecipeBuilder(RecipeCategory category, CookingBookCategory bookCategory, Ingredient result, Ingredient ingredient, int outputCount, float experience, int cookingTime, NodeCookingSerializer.Factory<T> factory) {
        this.category = category;
        this.bookCategory = bookCategory;
        this.result = result;
        this.ingredient = ingredient;
        this.outputCount = outputCount;
        this.experience = experience;
        this.cookingTime = cookingTime;
        this.factory = factory;
    }

    public static MetalNodeCookingRecipeBuilder<MetalNodeBlastingRecipe> blasting(Ingredient ingredient, RecipeCategory category, Ingredient result, int outputCount, float experience, int cookingTime) {
        return new MetalNodeCookingRecipeBuilder<MetalNodeBlastingRecipe>(category, CookingBookCategory.MISC, result, ingredient, outputCount, experience, cookingTime, MetalNodeBlastingRecipe::new);
    }

    public static MetalNodeCookingRecipeBuilder<MetalNodeSmeltingRecipe> smelting(Ingredient ingredient, RecipeCategory category, Ingredient result, int outputCount, float experience, int cookingTime) {
        return new MetalNodeCookingRecipeBuilder<MetalNodeSmeltingRecipe>(category, CookingBookCategory.MISC, result, ingredient, outputCount, experience, cookingTime, MetalNodeSmeltingRecipe::new);
    }

    public MetalNodeCookingRecipeBuilder<T> unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public MetalNodeCookingRecipeBuilder<T> group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    public T buildRecipe(ResourceLocation id) {
        return this.factory.create(this.group == null ? "" : this.group, this.ingredient, this.result, this.outputCount, this.experience, this.cookingTime);
    }
}

