/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.datagen.tag;

import com.mojang.datafixers.util.Either;
import com.sammy.malum.registry.common.MalumDamageTypes;
import com.sammy.malum.registry.common.MalumTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.DamageTypeTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.damagesource.DamageTypes;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import team.lodestar.lodestone.registry.common.tag.LodestoneDamageTypeTags;

public class MalumDamageTypeTagDatagen
extends DamageTypeTagsProvider {
    private static MalumDamageTypeTagDatagen DATAGEN;
    private final Function<ResourceKey<DamageType>, TagBuilder> MAGIC = type -> {
        TagBuilder builder = this.addTag((ResourceKey<DamageType>)type);
        builder.add(LodestoneDamageTypeTags.IS_MAGIC, MalumTags.DamageTypeTags.BYPASSES_HALF_ARMOR, MalumTags.DamageTypeTags.SOUL_SHATTER_DAMAGE, DamageTypeTags.BYPASSES_COOLDOWN, DamageTypeTags.AVOIDS_GUARDIAN_THORNS, DamageTypeTags.PANIC_CAUSES);
        builder.remove(DamageTypeTags.BYPASSES_SHIELD);
        return builder;
    };
    private final Function<ResourceKey<DamageType>, TagBuilder> PHYSICAL = type -> {
        TagBuilder builder = this.addTag((ResourceKey<DamageType>)type);
        builder.add(Tags.DamageTypes.IS_PHYSICAL, DamageTypeTags.PANIC_CAUSES, DamageTypeTags.CAN_BREAK_ARMOR_STAND);
        return builder;
    };
    private final Function<ResourceKey<DamageType>, TagBuilder> SCYTHE = type -> {
        TagBuilder builder = this.addTag((ResourceKey<DamageType>)type);
        builder.add(Tags.DamageTypes.IS_PHYSICAL, MalumTags.DamageTypeTags.IS_SCYTHE, MalumTags.DamageTypeTags.SOUL_SHATTER_DAMAGE, DamageTypeTags.PANIC_CAUSES, DamageTypeTags.CAN_BREAK_ARMOR_STAND);
        return builder;
    };
    private final Function<ResourceKey<DamageType>, TagBuilder> TRUE_DAMAGE = type -> {
        TagBuilder builder = this.addTag((ResourceKey<DamageType>)type);
        builder.add(DamageTypeTags.BYPASSES_ARMOR, DamageTypeTags.BYPASSES_SHIELD, DamageTypeTags.BYPASSES_INVULNERABILITY, DamageTypeTags.BYPASSES_COOLDOWN, DamageTypeTags.BYPASSES_EFFECTS, DamageTypeTags.BYPASSES_RESISTANCE, DamageTypeTags.BYPASSES_ENCHANTMENTS);
        return builder;
    };

    public MalumDamageTypeTagDatagen(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pProvider, ExistingFileHelper existingFileHelper) {
        super(pOutput, pProvider, "malum", existingFileHelper);
        DATAGEN = this;
    }

    protected void addTags(HolderLookup.Provider pProvider) {
        this.MAGIC.apply(MalumDamageTypes.VOODOO).add(DamageTypeTags.NO_KNOCKBACK);
        this.MAGIC.apply(MalumDamageTypes.VOODOO_PLAYERLESS).add(DamageTypeTags.NO_KNOCKBACK);
        this.MAGIC.apply(MalumDamageTypes.NITRATE).add(MalumTags.DamageTypeTags.IS_NITRATE, DamageTypeTags.IS_EXPLOSION);
        this.MAGIC.apply(MalumDamageTypes.NITRATE_PLAYERLESS).add(MalumTags.DamageTypeTags.IS_NITRATE, DamageTypeTags.IS_EXPLOSION);
        this.TRUE_DAMAGE.apply(MalumDamageTypes.VOID).add(LodestoneDamageTypeTags.IS_MAGIC, DamageTypeTags.NO_KNOCKBACK);
        this.MAGIC.apply(MalumDamageTypes.KARMIC).add(DamageTypeTags.NO_KNOCKBACK);
        this.MAGIC.apply(MalumDamageTypes.ROT).add(DamageTypeTags.NO_KNOCKBACK);
        this.SCYTHE.apply(MalumDamageTypes.SCYTHE_MELEE).add(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC, MalumTags.DamageTypeTags.IS_SCYTHE_MELEE, DamageTypeTags.IS_PLAYER_ATTACK);
        this.SCYTHE.apply(MalumDamageTypes.SCYTHE_SWEEP).add(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC, MalumTags.DamageTypeTags.IS_SCYTHE_MELEE);
        this.SCYTHE.apply(MalumDamageTypes.SCYTHE_REBOUND).add(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC, DamageTypeTags.IS_PROJECTILE);
        this.SCYTHE.apply(MalumDamageTypes.SCYTHE_ASCENSION).add(LodestoneDamageTypeTags.CAN_TRIGGER_MAGIC, MalumTags.DamageTypeTags.IS_SCYTHE_MELEE);
        this.SCYTHE.apply(MalumDamageTypes.SCYTHE_COMBO).add(DamageTypeTags.BYPASSES_COOLDOWN, DamageTypeTags.NO_KNOCKBACK);
        this.SCYTHE.apply(MalumDamageTypes.SCYTHE_MAELSTROM).add(DamageTypeTags.BYPASSES_COOLDOWN, DamageTypeTags.NO_KNOCKBACK);
        this.SCYTHE.apply(MalumDamageTypes.HIDDEN_BLADE_PHYSICAL_COUNTER).add(MalumTags.DamageTypeTags.IS_HIDDEN_BLADE, DamageTypeTags.BYPASSES_COOLDOWN, DamageTypeTags.NO_KNOCKBACK);
        this.MAGIC.apply(MalumDamageTypes.HIDDEN_BLADE_MAGIC_COUNTER).add(MalumTags.DamageTypeTags.IS_HIDDEN_BLADE, DamageTypeTags.BYPASSES_COOLDOWN, DamageTypeTags.NO_KNOCKBACK);
        this.MAGIC.apply(MalumDamageTypes.TYRVING);
        this.PHYSICAL.apply(MalumDamageTypes.SUNDERING_ANCHOR_PHYSICAL_COMBO).add(MalumTags.DamageTypeTags.IS_SUNDERING_ANCHOR_COMBO, DamageTypeTags.NO_KNOCKBACK).remove(DamageTypeTags.BYPASSES_SHIELD);
        this.MAGIC.apply(MalumDamageTypes.SUNDERING_ANCHOR_MAGIC_COMBO).add(MalumTags.DamageTypeTags.IS_SUNDERING_ANCHOR_COMBO, DamageTypeTags.NO_KNOCKBACK).remove(DamageTypeTags.BYPASSES_SHIELD);
        this.PHYSICAL.apply(MalumDamageTypes.UNMAKERS_DISDAIN_COMBO).add(DamageTypeTags.NO_KNOCKBACK);
        this.MAGIC.apply(MalumDamageTypes.WARLOCK_SPIRIT_IMPACT);
        this.MAGIC.apply(MalumDamageTypes.BERSERKER_SPIRIT_IMPACT);
        this.MAGIC.apply(MalumDamageTypes.INVERTED_HEART_RETALIATION).add(MalumTags.DamageTypeTags.IS_INVERTED_HEART);
        this.MAGIC.apply(MalumDamageTypes.INVERTED_HEART_PROPAGATION).add(MalumTags.DamageTypeTags.IS_INVERTED_HEART);
        this.addToTag(MalumTags.DamageTypeTags.INVERTED_HEART_PROPAGATION_BLACKLIST).add(MalumDamageTypes.SCYTHE_SWEEP, DamageTypes.THORNS).add(MalumTags.DamageTypeTags.IS_INVERTED_HEART, Tags.DamageTypes.IS_TECHNICAL);
        this.addToTag(MalumTags.DamageTypeTags.INVERTED_HEART_RETALIATION_BLACKLIST).add(MalumTags.DamageTypeTags.IS_INVERTED_HEART, Tags.DamageTypes.IS_TECHNICAL);
        this.addToTag(MalumTags.DamageTypeTags.GLEEFUL_TARGET_BLACKLIST).add(DamageTypeTags.BYPASSES_ARMOR);
    }

    public TagBuilder addTag(ResourceKey<DamageType> target) {
        return new TagBuilder(target);
    }

    public TagBuilder addToTag(TagKey<DamageType> target) {
        return new TagBuilder(target);
    }

    public static class TagBuilder {
        private final Either<ResourceKey<DamageType>, TagKey<DamageType>> target;

        public TagBuilder(ResourceKey<DamageType> target) {
            this.target = Either.left(target);
        }

        public TagBuilder(TagKey<DamageType> target) {
            this.target = Either.right(target);
        }

        @SafeVarargs
        public final TagBuilder add(TagKey<DamageType> ... tags) {
            return this.add(List.of(tags));
        }

        public final TagBuilder add(List<TagKey<DamageType>> tags) {
            for (TagKey<DamageType> tag : tags) {
                this.target.ifLeft(left -> DATAGEN.tag(tag).add(left));
                this.target.ifRight(right -> DATAGEN.tag(right).addTag(tag));
            }
            return this;
        }

        @SafeVarargs
        public final TagBuilder remove(TagKey<DamageType> ... damageTypes) {
            for (TagKey<DamageType> tag : damageTypes) {
                this.target.ifLeft(left -> DATAGEN.tag(tag).remove(left));
                this.target.ifRight(right -> DATAGEN.tag(right).remove(tag));
            }
            return this;
        }

        @SafeVarargs
        public final TagBuilder add(ResourceKey<DamageType> ... damageType) {
            for (ResourceKey<DamageType> type : damageType) {
                this.target.ifRight(right -> DATAGEN.tag(right).add(type));
            }
            return this;
        }
    }
}

