/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.events;

import com.sammy.malum.client.scarf.ScarfRenderHandler;
import com.sammy.malum.common.item.GeasItem;
import com.sammy.malum.common.item.augment.AugmentItem;
import com.sammy.malum.core.handlers.client.HiddenBladeRenderHandler;
import com.sammy.malum.core.handlers.client.SoulWardRenderHandler;
import com.sammy.malum.core.handlers.client.StaffAbilityRenderHandler;
import com.sammy.malum.core.handlers.client.WaveformConfigurationHandler;
import com.sammy.malum.core.systems.item.HeldItemTracker;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class ClientRuntimeEvents {
    @SubscribeEvent
    public static void renderOverlay(RenderGuiLayerEvent.Post event) {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void lateRenderTick(RenderFrameEvent.Post event) {
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderStages(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_LEVEL)) {
            ScarfRenderHandler.renderScarfData(event);
        }
    }

    @SubscribeEvent
    public static void clientTickEvent(ClientTickEvent.Pre event) {
        HeldItemTracker.tickTrackers();
        ScarfRenderHandler.tickScarfData((ClientTickEvent)event);
        HiddenBladeRenderHandler.tick((ClientTickEvent)event);
        SoulWardRenderHandler.tick((ClientTickEvent)event);
        StaffAbilityRenderHandler.tick((ClientTickEvent)event);
        WaveformConfigurationHandler.tick((ClientTickEvent)event);
    }

    @SubscribeEvent
    public static void itemTooltipEvent(ItemTooltipEvent event) {
        GeasItem.addGeasTooltip(event);
        AugmentItem.addAugmentAttributeTooltip(event);
    }

    @SubscribeEvent
    public static void onBlockActivated(PlayerInteractEvent.RightClickBlock event) {
        WaveformConfigurationHandler.onBlockActivated(event);
    }
}

