/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.handlers.RenderHandler;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.helpers.VecHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.render_types.LodestoneWorldParticleRenderType;
import team.lodestar.lodestone.systems.particle.world.behaviors.DirectionalParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.LodestoneParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.behaviors.SparkParticleBehavior;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class GluttonyParticleEffects {
    private static final Color GLUTTONY_GREEN = new Color(47, 81, 28);
    private static final Color GLUTTONY_DARK = new Color(31, 35, 30);
    private static final Color GLUTTONY_SHADE = new Color(14, 14, 16);

    public static void incrementGluttonyStatusEffect(NetworkedParticleEffectPositionData positionData, float gluttonyPotency) {
        ClientLevel level = Minecraft.getInstance().level;
        RandomSource random = level.random;
        for (int i = 0; i < 2; ++i) {
            int lifetime = RandomHelper.randomBetween((RandomSource)random, (int)20, (int)30);
            WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.WISP_PARTICLE).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.7f, (float)0.0f).build().multiplyValue(gluttonyPotency)).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.05f).build()).setScaleData(GenericParticleData.create((float)0.2f, (float)0.75f, (float)0.0f).setCoefficient(1.25f).setEasing(Easing.SINE_IN, Easing.SINE_IN_OUT).build()).setLifetime(lifetime).setColorData(ColorParticleData.create((Color)GLUTTONY_DARK, (Color)GLUTTONY_SHADE).setCoefficient(2.0f).build()).enableNoClip().setRandomOffset((double)0.2f, 0.0).setMotion(0.0, (double)0.001f, 0.0).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT.withDepthFade()).repeat((Level)level, positionData.getPosX(), positionData.getPosY(), positionData.getPosZ(), 2);
        }
        float distance = 0.7f;
        float length = 1.4f * gluttonyPotency;
        float scale = 0.6f * gluttonyPotency;
        int count = gluttonyPotency < 1.0f ? 6 : 8;
        ParticleEffectSpawner ring = GluttonyParticleEffects.gluttonyRing(positionData.getAsVector(), new WorldParticleOptions(LodestoneParticleTypes.SPARKLE_PARTICLE), distance, count);
        ring.getBuilder().modifyData(AbstractParticleBuilder::getLengthData, d -> d.multiplyValue(length)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.multiplyValue(gluttonyPotency)).setScaleData(GenericParticleData.create((float)scale, (float)0.0f).setEasing(Easing.SINE_IN).build());
        ring.spawnParticles();
    }

    public static void thrownGluttonySplash(NetworkedParticleEffectPositionData positionData) {
        ClientLevel level = Minecraft.getInstance().level;
        RandomSource random = level.random;
        for (int i = 0; i < 4; ++i) {
            int lifetime = RandomHelper.randomBetween((RandomSource)random, (int)30, (int)40);
            WorldParticleBuilder.create((Supplier)LodestoneParticleTypes.WISP_PARTICLE).setBehavior((LodestoneParticleBehavior)DirectionalParticleBehavior.directional()).setTransparencyData(GenericParticleData.create((float)0.2f, (float)0.7f, (float)0.0f).build()).setColorData(ColorParticleData.create((Color)GLUTTONY_DARK, (Color)GLUTTONY_SHADE).setCoefficient(2.0f).build()).setScaleData(GenericParticleData.create((float)2.0f, (float)0.0f).setEasing(Easing.EXPO_IN).build()).setSpinData(SpinParticleData.createRandomDirection((RandomSource)random, (float)0.05f).build()).setRenderType((ParticleRenderType)LodestoneWorldParticleRenderType.LUMITRANSPARENT.withDepthFade()).setRandomOffset(1.0, 0.0).setMotion(0.0, (double)0.001f, 0.0).setLifetime(lifetime).enableNoClip().repeat((Level)level, positionData.getPosX(), positionData.getPosY(), positionData.getPosZ(), 2);
        }
        Supplier particle = LodestoneParticleTypes.THIN_EXTRUDING_SPARK_PARTICLE;
        ParticleEffectSpawner ring = GluttonyParticleEffects.gluttonyRing(positionData.getAsVector(), new WorldParticleOptions(particle), 1.2f, 32);
        ring.spawnParticles();
        ring = GluttonyParticleEffects.gluttonyRing(positionData.getAsVector(), new WorldParticleOptions(particle), 0.4f, 16, 0.5f);
        ring.getBuilder().modifyData(AbstractParticleBuilder::getLengthData, d -> d.multiplyValue(0.5f));
        ring.spawnParticles();
    }

    public static ParticleEffectSpawner gluttonyRing(Vec3 center, WorldParticleOptions options, float distance, int count) {
        return GluttonyParticleEffects.gluttonyRing(center, options, distance, count, 1.0f);
    }

    public static ParticleEffectSpawner gluttonyRing(Vec3 center, WorldParticleOptions options, float distance, int count, float lifetimeScalar) {
        ClientLevel level = Minecraft.getInstance().level;
        RandomSource random = level.random;
        WorldParticleBuilder builder = WorldParticleBuilder.create((WorldParticleOptions)options.setBehaviorIfDefault((LodestoneParticleBehavior)SparkParticleBehavior.sparkBehavior().setLengthCenter(1.0f))).setLengthData(GenericParticleData.create((float)0.1f, (float)0.5f, (float)0.0f).setEasing(Easing.SINE_IN_OUT, Easing.SINE_IN_OUT).setCoefficient(1.25f).build()).setScaleData(GenericParticleData.create((float)0.025f, (float)RandomHelper.randomBetween((RandomSource)random, (float)0.2f, (float)0.3f), (float)0.0f).build()).setTransparencyData(GenericParticleData.create((float)0.8f, (float)0.0f).build());
        return GluttonyParticleEffects.gluttonyRing(center, builder, distance, count, lifetimeScalar);
    }

    public static ParticleEffectSpawner gluttonyRing(Vec3 center, WorldParticleBuilder builder, float distance, int count) {
        return GluttonyParticleEffects.gluttonyRing(center, builder, distance, count, 1.0f);
    }

    public static ParticleEffectSpawner gluttonyRing(Vec3 center, WorldParticleBuilder builder, float distance, int count, float lifetimeScalar) {
        ClientLevel level = Minecraft.getInstance().level;
        long gameTime = level.getGameTime();
        RandomSource random = level.random;
        return new ParticleEffectSpawner(builder, arg_0 -> GluttonyParticleEffects.lambda$gluttonyRing$6(count, center, distance, gameTime, random, builder, lifetimeScalar, (Level)level, arg_0));
    }

    private static /* synthetic */ void lambda$gluttonyRing$6(int count, Vec3 center, float distance, long gameTime, RandomSource random, WorldParticleBuilder builder, float lifetimeScalar, Level level, WorldParticleBuilder b) {
        for (int i = 0; i < count; ++i) {
            Vec3 offsetPosition = VecHelper.rotatingRadialOffset((Vec3)center, (float)distance, (float)i, (float)count, (float)gameTime, (float)320.0f);
            for (int j = 0; j < 3; ++j) {
                boolean isAdditive = j == 0;
                Color bright = j < 2 ? GLUTTONY_GREEN : GLUTTONY_DARK;
                Color dark = j < 2 ? GLUTTONY_GREEN : GLUTTONY_SHADE;
                float alphaMultiplier = isAdditive ? 1.5f : 3.0f;
                float scaleMultiplier = (isAdditive ? 1.25f : 2.5f) * RandomHelper.randomBetween((RandomSource)random, (float)0.8f, (float)1.2f);
                float lengthMultiplier = (isAdditive ? 0.75f : 1.25f) * RandomHelper.randomBetween((RandomSource)random, (float)0.8f, (float)1.2f);
                float colorCoefficient = isAdditive ? 1.0f : 1.75f;
                LodestoneWorldParticleRenderType renderType = isAdditive ? LodestoneWorldParticleRenderType.ADDITIVE : LodestoneWorldParticleRenderType.LUMITRANSPARENT;
                RenderHandler.LodestoneRenderLayer renderTarget = j < 2 ? RenderHandler.LATE_DELAYED_RENDER : RenderHandler.DELAYED_RENDER;
                builder.modifyData(AbstractParticleBuilder::getLengthData, d -> d.bake().multiplyValue(lengthMultiplier)).modifyData(AbstractParticleBuilder::getTransparencyData, d -> d.bake().multiplyValue(alphaMultiplier)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.bake().multiplyValue(scaleMultiplier)).setColorData(ColorParticleData.create((Color)bright, (Color)dark).setCoefficient(colorCoefficient).build()).setLifetime((int)((float)RandomHelper.randomBetween((RandomSource)random, (int)30, (int)60) * lifetimeScalar)).setMotion(0.0, (double)0.001f, 0.0).setRenderTarget(renderTarget).setRenderType((ParticleRenderType)renderType).enableNoClip().spawn(level, offsetPosition.x, offsetPosition.y, offsetPosition.z);
            }
        }
    }
}

