/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects;

import com.sammy.malum.core.systems.spirit.MalumSpiritType;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import java.util.function.Consumer;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.registry.common.particle.LodestoneParticleTypes;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.WorldParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.GenericParticleData;
import team.lodestar.lodestone.systems.particle.data.spin.SpinParticleData;
import team.lodestar.lodestone.systems.particle.world.LodestoneWorldParticle;
import team.lodestar.lodestone.systems.particle.world.options.LodestoneItemCrumbsParticleOptions;
import team.lodestar.lodestone.systems.particle.world.options.WorldParticleOptions;

public class ItemCrumbleParticleEffects {
    public static ParticleEffectSpawner spawnItemCrumbs(Level level, Vec3 pos, ItemStack stack) {
        RandomSource rand = level.getRandom();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)Mth.nextFloat((RandomSource)rand, (float)0.5f, (float)0.75f), (float)0.0f).setCoefficient(0.6f).randomSpinOffset(rand).build();
        Consumer<LodestoneWorldParticle> slowDown = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.925f));
        int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)30, (int)40);
        WorldParticleBuilder crumbs = ItemCrumbleParticleEffects.makeCrumbs(rand, stack, spinData, lifetime, slowDown);
        return new ParticleEffectSpawner(level, pos, crumbs);
    }

    public static ParticleEffectSpawner spawnGlowingItemCrumbs(Level level, Vec3 pos, ItemStack stack, MalumSpiritType spiritType) {
        RandomSource rand = level.getRandom();
        SpinParticleData spinData = SpinParticleData.createRandomDirection((RandomSource)rand, (float)0.0f, (float)Mth.nextFloat((RandomSource)rand, (float)0.5f, (float)0.75f), (float)0.0f).setCoefficient(0.6f).randomSpinOffset(rand).build();
        Consumer<LodestoneWorldParticle> slowDown = p -> p.setParticleSpeed(p.getParticleSpeed().scale((double)0.925f));
        int lifetime = RandomHelper.randomBetween((RandomSource)rand, (int)30, (int)40);
        WorldParticleBuilder crumbs = ItemCrumbleParticleEffects.makeCrumbs(rand, stack, spinData, lifetime, slowDown);
        WorldParticleBuilder bloom = SpiritLightSpecs.spiritBloom(level, spiritType, lifetime).setSpinData(spinData).addTickActor(slowDown);
        return new ParticleEffectSpawner(level, pos, crumbs, bloom);
    }

    public static WorldParticleBuilder makeCrumbs(RandomSource rand, ItemStack stack, SpinParticleData spinData, int lifetime, Consumer<LodestoneWorldParticle> slowDown) {
        LodestoneItemCrumbsParticleOptions options = new LodestoneItemCrumbsParticleOptions((ParticleType)LodestoneParticleTypes.ITEM_PARTICLE.get(), stack);
        return WorldParticleBuilder.create((WorldParticleOptions)options).setSpinData(spinData).setTransparencyData(GenericParticleData.create((float)0.5f, (float)1.0f, (float)0.25f).setEasing(Easing.EXPO_IN, Easing.SINE_IN_OUT).build()).setScaleData(GenericParticleData.create((float)0.05f, (float)RandomHelper.randomBetween((RandomSource)rand, (float)0.06f, (float)0.07f), (float)0.0f).build()).setLifetime(lifetime).setRenderType(ParticleRenderType.TERRAIN_SHEET).addTickActor(slowDown);
    }
}

