/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.visual_effects.networked.staff;

import com.sammy.malum.visual_effects.SparkParticleEffects;
import com.sammy.malum.visual_effects.SpiritLightSpecs;
import com.sammy.malum.visual_effects.networked.MalumNetworkedParticleEffectColorData;
import com.sammy.malum.visual_effects.networked.staff.BoltImpactParticleEffect;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.lodestar.lodestone.helpers.RandomHelper;
import team.lodestar.lodestone.systems.network.particle.NetworkedParticleEffectPositionData;
import team.lodestar.lodestone.systems.particle.ParticleEffectSpawner;
import team.lodestar.lodestone.systems.particle.builder.AbstractParticleBuilder;
import team.lodestar.lodestone.systems.particle.data.color.ColorParticleData;

public class HexBoltImpactParticleEffect
extends BoltImpactParticleEffect {
    public HexBoltImpactParticleEffect(String id) {
        super(id);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void act(Level level, RandomSource random, NetworkedParticleEffectPositionData positionData, MalumNetworkedParticleEffectColorData colorData, Vec3 projectileDirection, Vec3 left, Vec3 up) {
        Vec3 pos = positionData.getAsVector();
        for (int i = 0; i < 32; ++i) {
            ColorParticleData color = colorData.getColor();
            float spread = RandomHelper.randomBetween((RandomSource)random, (float)0.1f, (float)0.5f);
            float speed = RandomHelper.randomBetween((RandomSource)random, (float)0.3f, (float)0.4f);
            float distance = RandomHelper.randomBetween((RandomSource)random, (float)3.0f, (float)6.0f);
            float angle = (float)i / 32.0f * (float)Math.PI * 2.0f;
            Vec3 direction = projectileDirection.add(left.scale(Math.sin(angle) * (double)spread)).add(up.scale(Math.cos(angle) * (double)spread)).normalize().scale((double)speed);
            Vec3 spawnPosition = pos.add(direction.scale((double)distance));
            direction = direction.reverse();
            float lifetimeMultiplier = 0.7f;
            if (random.nextFloat() < 0.8f) {
                ParticleEffectSpawner lightSpecs = SpiritLightSpecs.spiritLightSpecs(level, spawnPosition, color);
                lightSpecs.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.75f)).setMotion(direction);
                lightSpecs.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).setMotion(direction);
                lightSpecs.spawnParticles();
            }
            if (!(random.nextFloat() < 0.8f)) continue;
            ParticleEffectSpawner sparks = SparkParticleEffects.spiritMotionSparks(level, spawnPosition, color);
            sparks.getBuilder().multiplyLifetime(lifetimeMultiplier).enableForcedSpawn().setMotion(direction.scale(1.5)).modifyData(AbstractParticleBuilder::getScaleData, d -> d.multiplyValue(1.75f)).modifyData(AbstractParticleBuilder::getLengthData, d -> d.multiplyValue(3.0f));
            sparks.getBloomBuilder().multiplyLifetime(lifetimeMultiplier).setMotion(direction.scale(1.5));
            sparks.spawnParticles();
        }
    }
}

