/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.client.gui.v2.components.tooltip;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public final class ClientComponentSplitter {
    private ClientComponentSplitter() {
    }

    public static Stream<FormattedCharSequence> splitTooltipLines(FormattedText ... tooltipLines) {
        return ClientComponentSplitter.splitTooltipLines(170, Arrays.asList(tooltipLines));
    }

    public static Stream<FormattedCharSequence> splitTooltipLines(int maxWidth, FormattedText ... tooltipLines) {
        return ClientComponentSplitter.splitTooltipLines(maxWidth, Arrays.asList(tooltipLines));
    }

    public static Stream<FormattedCharSequence> splitTooltipLines(List<? extends FormattedText> tooltipLines) {
        return ClientComponentSplitter.splitTooltipLines(170, tooltipLines);
    }

    public static Stream<FormattedCharSequence> splitTooltipLines(int maxWidth, List<? extends FormattedText> tooltipLines) {
        return tooltipLines.stream().flatMap(formattedText -> {
            List lines = Minecraft.getInstance().font.split(formattedText, maxWidth);
            if (lines.isEmpty()) {
                return Stream.of(FormattedCharSequence.EMPTY);
            }
            return lines.stream();
        });
    }

    public static Stream<FormattedCharSequence> processTooltipLines(FormattedText ... tooltipLines) {
        return ClientComponentSplitter.processTooltipLines(Arrays.asList(tooltipLines));
    }

    public static Stream<FormattedCharSequence> processTooltipLines(List<? extends FormattedText> tooltipLines) {
        return tooltipLines.stream().map(formattedText -> ClientLanguage.getInstance().getVisualOrder(formattedText));
    }
}

