/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public interface PlayerSet {
    public void broadcast(CustomPacketPayload.Type<?> var1, Packet<?> var2);

    public static PlayerSet ofNone() {
        return (type, packet) -> {};
    }

    public static PlayerSet ofEntity(Entity entity) {
        PlayerSet playerSet;
        Objects.requireNonNull(entity, "entity is null");
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            playerSet = PlayerSet.ofPlayer(serverPlayer);
        } else {
            playerSet = PlayerSet.ofNone();
        }
        return playerSet;
    }

    public static PlayerSet ofPlayer(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return (type, packet) -> {
            if (CommonAbstractions.INSTANCE.hasChannel(serverPlayer, type)) {
                serverPlayer.connection.send(packet);
            }
        };
    }

    public static PlayerSet ofOthers(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return (type, packet) -> serverPlayer.getServer().getPlayerList().getPlayers().forEach(currentServerPlayer -> {
            if (currentServerPlayer != serverPlayer) {
                PlayerSet.ofPlayer(currentServerPlayer).broadcast(type, packet);
            }
        });
    }

    public static PlayerSet ofAll(MinecraftServer minecraftServer) {
        return (type, packet) -> minecraftServer.getPlayerList().getPlayers().forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).broadcast(type, packet));
    }

    public static PlayerSet inLevel(ServerLevel serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return (type, packet) -> {
            for (ServerPlayer serverPlayer : serverLevel.players()) {
                PlayerSet.ofPlayer(serverPlayer).broadcast(type, packet);
            }
        };
    }

    public static PlayerSet nearPosition(Vec3i position, ServerLevel serverLevel) {
        Objects.requireNonNull(position, "position is null");
        return PlayerSet.nearPosition(position.getX(), position.getY(), position.getZ(), serverLevel);
    }

    public static PlayerSet nearPosition(double posX, double posY, double posZ, ServerLevel serverLevel) {
        return PlayerSet.nearPosition(null, posX, posY, posZ, 64.0, serverLevel);
    }

    public static PlayerSet nearPosition(@Nullable ServerPlayer excludePlayer, double posX, double posY, double posZ, double distance, ServerLevel serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return (type, packet) -> {
            for (ServerPlayer serverPlayer : serverLevel.getServer().getPlayerList().getPlayers()) {
                double deltaZ;
                double deltaY;
                double deltaX;
                if (serverPlayer == excludePlayer || serverPlayer.level().dimension() != serverLevel.dimension() || !((deltaX = posX - serverPlayer.getX()) * deltaX + (deltaY = posY - serverPlayer.getY()) * deltaY + (deltaZ = posZ - serverPlayer.getZ()) * deltaZ < distance * distance)) continue;
                PlayerSet.ofPlayer(serverPlayer).broadcast(type, packet);
            }
        };
    }

    public static PlayerSet nearBlockEntity(BlockEntity blockEntity) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        Level level = blockEntity.getLevel();
        Objects.requireNonNull(level, "block entity level is null");
        return level.isClientSide ? PlayerSet.ofNone() : PlayerSet.nearPosition((Vec3i)blockEntity.getBlockPos(), (ServerLevel)level);
    }

    public static PlayerSet nearChunk(LevelChunk levelChunk) {
        Objects.requireNonNull(levelChunk, "chunk is null");
        return levelChunk.getLevel().isClientSide ? PlayerSet.ofNone() : PlayerSet.nearChunk((ServerLevel)levelChunk.getLevel(), levelChunk.getPos());
    }

    public static PlayerSet nearChunk(ServerLevel serverLevel, ChunkPos chunkPos) {
        Objects.requireNonNull(serverLevel, "server level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        return (type, packet) -> serverLevel.getChunkSource().chunkMap.getPlayers(chunkPos, false).forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).broadcast(type, packet));
    }

    public static PlayerSet nearEntity(Entity entity) {
        Objects.requireNonNull(entity, "entity is null");
        return entity.getCommandSenderWorld().isClientSide ? PlayerSet.ofNone() : (type, packet) -> {
            ChunkMap chunkMap = ((ServerLevel)entity.getCommandSenderWorld()).getChunkSource().chunkMap;
            ChunkMap.TrackedEntity trackedEntity = (ChunkMap.TrackedEntity)chunkMap.entityMap.get(entity.getId());
            if (trackedEntity != null) {
                for (ServerPlayerConnection serverPlayerConnection : trackedEntity.seenBy) {
                    PlayerSet.ofPlayer(serverPlayerConnection.getPlayer()).broadcast(type, packet);
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity;
                    PlayerSet.ofPlayer(serverPlayer).broadcast(type, packet);
                }
            }
        };
    }

    public static PlayerSet nearPlayer(ServerPlayer serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return (type, packet) -> {
            ChunkMap chunkMap = serverPlayer.serverLevel().getChunkSource().chunkMap;
            ChunkMap.TrackedEntity trackedEntity = (ChunkMap.TrackedEntity)chunkMap.entityMap.get(serverPlayer.getId());
            if (trackedEntity != null) {
                for (ServerPlayerConnection serverPlayerConnection : trackedEntity.seenBy) {
                    PlayerSet.ofPlayer(serverPlayerConnection.getPlayer()).broadcast(type, packet);
                }
            }
        };
    }
}

