/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import net.bettercombat.BetterCombatMod;
import net.bettercombat.api.AttributesContainer;
import net.bettercombat.config.FallbackConfig;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.utils.PatternMatching;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public class WeaponAttributesFallback {
    public static void initialize() {
        FallbackConfig config = (FallbackConfig)BetterCombatMod.fallbackConfig.value;
        block0: for (ResourceLocation itemId : BuiltInRegistries.ITEM.keySet()) {
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (PatternMatching.matches(itemId.toString(), config.blacklist_item_id_regex)) continue;
            FallbackConfig.CompatibilitySpecifier[] specifiers = null;
            if (WeaponAttributesFallback.hasAttributeModifier(item, (Holder<Attribute>)Attributes.ATTACK_DAMAGE)) {
                specifiers = config.fallback_compatibility;
            } else if (item instanceof ProjectileWeaponItem) {
                specifiers = config.ranged_weapons;
            }
            if (specifiers == null) continue;
            for (FallbackConfig.CompatibilitySpecifier fallbackOption : specifiers) {
                AttributesContainer container;
                if (WeaponRegistry.getAttributes(itemId) != null || !PatternMatching.matches(itemId.toString(), fallbackOption.item_id_regex) || (container = WeaponRegistry.containers.get(ResourceLocation.parse((String)fallbackOption.weapon_attributes))) == null) continue;
                WeaponRegistry.resolveAndRegisterAttributes(itemId, container);
                continue block0;
            }
        }
    }

    private static boolean hasAttributeModifier(Item item, Holder<Attribute> searchedAttribute) {
        ItemAttributeModifiers attributes = (ItemAttributeModifiers)item.components().get(DataComponents.ATTRIBUTE_MODIFIERS);
        for (ItemAttributeModifiers.Entry entry : attributes.modifiers()) {
            Holder attribute = entry.attribute();
            if (attribute != searchedAttribute && !attribute.equals(searchedAttribute)) continue;
            return true;
        }
        return false;
    }
}

