/*
 * Decompiled with CFR 0.152.
 */
package guideme.document.block;

import guideme.color.ColorValue;
import guideme.color.SymbolicColor;
import guideme.document.DefaultStyles;
import guideme.document.LytRect;
import guideme.document.block.LytList;
import guideme.document.block.LytNode;
import guideme.document.block.LytVBox;
import guideme.layout.LayoutContext;
import guideme.render.RenderContext;
import guideme.style.ResolvedTextStyle;
import net.minecraft.client.renderer.MultiBufferSource;

public class LytListItem
extends LytVBox {
    private static final int LEVEL_MARGIN = 10;
    private final ResolvedTextStyle style = DefaultStyles.BODY_TEXT.mergeWith(DefaultStyles.BASE_STYLE);

    private boolean isOrdered() {
        LytNode lytNode = this.parent;
        if (lytNode instanceof LytList) {
            LytList list = (LytList)lytNode;
            return list.isOrdered();
        }
        return false;
    }

    @Override
    protected LytRect computeBoxLayout(LayoutContext context, int x, int y, int availableWidth) {
        int margin = 10;
        LytRect bounds = super.computeBoxLayout(context, x + margin, y, availableWidth - margin);
        return bounds.expand(10, 0, 0, 0);
    }

    @Override
    public void renderBatch(RenderContext context, MultiBufferSource buffers) {
        if (this.isOrdered()) {
            int number = this.getOrderedItemNumber();
            String label = number + ".";
            float width = context.getWidth(label, this.style);
            LytRect bounds = this.getBounds();
            float x = (float)(bounds.x() + 10) - width - 2.0f;
            context.renderTextInBatch(label, this.style, x, bounds.y(), buffers);
        }
        super.renderBatch(context, buffers);
    }

    private int getOrderedItemNumber() {
        int number = 1;
        Object object = this.parent;
        if (object instanceof LytList) {
            LytNode child;
            LytList list = (LytList)object;
            number = list.getStart();
            object = list.getChildren().iterator();
            while (object.hasNext() && (child = (LytNode)object.next()) != this) {
                if (!(child instanceof LytListItem)) continue;
                ++number;
            }
        }
        return number;
    }

    @Override
    public void render(RenderContext context) {
        if (!this.isOrdered()) {
            LytRect bounds = this.getBounds();
            context.fillRect(bounds.x() + 5, bounds.y() + 4, 2, 2, (ColorValue)SymbolicColor.BODY_TEXT);
        }
        super.render(context);
    }
}

