/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.document;

import guideme.internal.shaded.lucene.document.ShapeDocValues;
import guideme.internal.shaded.lucene.document.ShapeField;
import guideme.internal.shaded.lucene.document.SpatialQuery;
import guideme.internal.shaded.lucene.geo.Component2D;
import guideme.internal.shaded.lucene.geo.Geometry;
import guideme.internal.shaded.lucene.index.BinaryDocValues;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.LeafReader;
import guideme.internal.shaded.lucene.index.PointValues;
import guideme.internal.shaded.lucene.search.ConstantScoreScorer;
import guideme.internal.shaded.lucene.search.ScoreMode;
import guideme.internal.shaded.lucene.search.Scorer;
import guideme.internal.shaded.lucene.search.ScorerSupplier;
import guideme.internal.shaded.lucene.search.TwoPhaseIterator;
import guideme.internal.shaded.lucene.util.BytesRef;
import java.io.IOException;

abstract class BaseShapeDocValuesQuery
extends SpatialQuery {
    BaseShapeDocValuesQuery(String field, ShapeField.QueryRelation queryRelation, Geometry ... geometries) {
        super(field, BaseShapeDocValuesQuery.validateRelation(queryRelation), geometries);
    }

    private static ShapeField.QueryRelation validateRelation(ShapeField.QueryRelation queryRelation) {
        if (queryRelation == ShapeField.QueryRelation.CONTAINS) {
            throw new IllegalArgumentException("ShapeDocValuesBoundingBoxQuery does not yet support CONTAINS queries");
        }
        return queryRelation;
    }

    protected abstract ShapeDocValues getShapeDocValues(BytesRef var1);

    @Override
    protected ScorerSupplier getScorerSupplier(final LeafReader reader, SpatialQuery.SpatialVisitor spatialVisitor, final ScoreMode scoreMode, final float boost, float score) throws IOException {
        final BinaryDocValues values = reader.getBinaryDocValues(this.field);
        if (values == null) {
            return null;
        }
        FieldInfo fieldInfo = reader.getFieldInfos().fieldInfo(this.field);
        if (fieldInfo == null) {
            return null;
        }
        final TwoPhaseIterator iterator = new TwoPhaseIterator(values){

            @Override
            public boolean matches() throws IOException {
                return BaseShapeDocValuesQuery.this.match(BaseShapeDocValuesQuery.this.getShapeDocValues(values.binaryValue()));
            }

            @Override
            public float matchCost() {
                return BaseShapeDocValuesQuery.this.matchCost();
            }
        };
        return new ScorerSupplier(this){

            @Override
            public Scorer get(long leadCost) {
                return new ConstantScoreScorer(boost, scoreMode, iterator);
            }

            @Override
            public long cost() {
                return reader.maxDoc();
            }
        };
    }

    protected boolean match(ShapeDocValues shapeDocValues) throws IOException {
        boolean result = this.matchesComponent(shapeDocValues, this.queryRelation, this.queryComponent2D);
        if (this.queryRelation == ShapeField.QueryRelation.DISJOINT) {
            return !result;
        }
        return result;
    }

    protected float matchCost() {
        return 6000.0f;
    }

    protected boolean matchesComponent(ShapeDocValues dv, ShapeField.QueryRelation queryRelation, Component2D component) throws IOException {
        PointValues.Relation r = dv.relate(component);
        if (r != PointValues.Relation.CELL_OUTSIDE_QUERY) {
            if (queryRelation == ShapeField.QueryRelation.WITHIN) {
                return r == PointValues.Relation.CELL_INSIDE_QUERY;
            }
            return true;
        }
        return false;
    }
}

