/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.BetterTags;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import wallywhip.BetterTags.initConfigs;
import wallywhip.BetterTags.nbtCommands;

@Mod(value="bettertags")
public class BetterTags {
    public static final String MOD_ID = "bettertags";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final initConfigs CONFIGURATION = new initConfigs();

    public BetterTags(ModContainer modContainer) {
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)BetterTags.CONFIGURATION.CLIENT);
        System.setProperty("java.awt.headless", "false");
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void ItemToolTipEvent(ItemTooltipEvent event) {
        boolean isFound;
        String st;
        LocalPlayer player;
        ItemStack itemStack = event.getItemStack();
        if (itemStack.isEmpty()) {
            return;
        }
        if (((Boolean)BetterTags.CONFIGURATION.showAsAdvanced.get()).booleanValue() && !event.getFlags().isAdvanced()) {
            return;
        }
        int BurnTime = itemStack.getBurnTime(null);
        if (BurnTime > 0) {
            String st2 = BetterTags.getTimeStringShort(BurnTime / 20) + " (" + BurnTime + ")";
            event.getToolTip().add(1, Component.translatable((String)"tip.bettertags.burn", (Object[])new Object[]{st2}).withStyle(ChatFormatting.GRAY));
        }
        if (itemStack.getMaxDamage() != 0 && itemStack.getDamageValue() == 0) {
            event.getToolTip().add(1, Component.translatable((String)"tip.bettertags.durability", (Object[])new Object[]{itemStack.getMaxDamage()}).withStyle(ChatFormatting.GRAY));
        }
        if (Screen.hasControlDown()) {
            int count = 0;
            for (TypedDataComponent t2 : itemStack.getComponents()) {
                if (count < 5) {
                    event.getToolTip().add(Component.literal((String)t2.type().toString()).withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)(" " + t2.value().toString())).withStyle(ChatFormatting.DARK_GRAY)));
                }
                ++count;
            }
            if (count >= 5) {
                event.getToolTip().add(Component.translatable((String)"tip.bettertags.more", (Object[])new Object[]{count - 5}).withStyle(ChatFormatting.DARK_GRAY));
            }
        } else {
            event.getToolTip().add(Component.translatable((String)"tip.bettertags.ctrl", (Object[])new Object[]{Component.translatable((String)"tip.ctrl").withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
        }
        Collection<ResourceLocation> iTag = BetterTags.getTags(itemStack.getTags());
        if (Screen.hasShiftDown()) {
            if (!iTag.isEmpty()) {
                event.getToolTip().add(Component.translatable((String)"tip.bettertags.item_tags").withStyle(ChatFormatting.GRAY));
                iTag.forEach(tag -> event.getToolTip().add(Component.literal((String)(" #" + tag.toString())).withStyle(ChatFormatting.DARK_GRAY)));
            }
            if ((block = Block.byItem((Item)itemStack.getItem())) != Blocks.AIR && !(iTag = BetterTags.getTags(block.defaultBlockState().getTags())).isEmpty()) {
                event.getToolTip().add(Component.translatable((String)"tip.bettertags.block_tags").withStyle(ChatFormatting.GRAY));
                iTag.forEach(tag -> event.getToolTip().add(Component.literal((String)(" #" + String.valueOf(tag))).withStyle(ChatFormatting.DARK_GRAY)));
            }
        } else {
            if (iTag.isEmpty() && (block = Block.byItem((Item)itemStack.getItem())) != Blocks.AIR) {
                iTag = BetterTags.getTags(block.defaultBlockState().getTags());
            }
            if (!iTag.isEmpty()) {
                event.getToolTip().add(Component.translatable((String)"tip.bettertags.shift", (Object[])new Object[]{Component.translatable((String)"tip.shift").withStyle(ChatFormatting.YELLOW)}).withStyle(ChatFormatting.GRAY));
            }
        }
        if (itemStack.getItem() == Items.SUSPICIOUS_STEW) {
            if (((Boolean)BetterTags.CONFIGURATION.showInfoStew.get()).booleanValue()) {
                ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
                SuspiciousStewEffects suspiciousStewEffects = (SuspiciousStewEffects)itemStack.getOrDefault(DataComponents.SUSPICIOUS_STEW_EFFECTS, (Object)SuspiciousStewEffects.EMPTY);
                for (SuspiciousStewEffects.Entry entry : suspiciousStewEffects.effects()) {
                    list.add(entry.createEffectInstance());
                }
                int line = 1;
                for (MobEffectInstance effect : list) {
                    ClientLevel level;
                    MutableComponent mutableComponent = Component.translatable((String)effect.getDescriptionId());
                    MobEffect mobEffect = (MobEffect)effect.getEffect().value();
                    if (effect.getAmplifier() > 0) {
                        mutableComponent = Component.translatable((String)"potion.withAmplifier", (Object[])new Object[]{mutableComponent, Component.translatable((String)("potion.potency." + effect.getAmplifier()))});
                    }
                    if (!effect.endsWithin(20) && (level = Minecraft.getInstance().level) != null) {
                        mutableComponent = Component.translatable((String)"potion.withDuration", (Object[])new Object[]{mutableComponent, MobEffectUtil.formatDuration((MobEffectInstance)effect, (float)1.0f, (float)level.tickRateManager().tickrate())});
                    }
                    String ss = mutableComponent.getString();
                    boolean isFound2 = event.getToolTip().stream().anyMatch(a -> a.getString().equals(ss));
                    if (isFound2) continue;
                    event.getToolTip().add(line++, mutableComponent.withStyle(mobEffect.getCategory().getTooltipFormatting()));
                }
            }
        } else if (itemStack.getItem() == Items.BEE_NEST || itemStack.getItem() == Items.BEEHIVE) {
            List de;
            if (((Boolean)BetterTags.CONFIGURATION.showInfoBees.get()).booleanValue() && (de = (List)itemStack.get(DataComponents.BEES)) != null) {
                if (de.isEmpty()) {
                    event.getToolTip().add(1, Component.translatable((String)"tip.bettertags.bee_empty").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                } else {
                    event.getToolTip().add(1, Component.translatable((String)"tip.bettertags.bees", (Object[])new Object[]{de.size()}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                }
                BlockItemStateProperties dd = (BlockItemStateProperties)itemStack.get(DataComponents.BLOCK_STATE);
                if (dd != null && !dd.isEmpty()) {
                    event.getToolTip().add(2, Component.translatable((String)"tip.bettertags.bee_level", (Object[])new Object[]{dd.get((Property)BeehiveBlock.HONEY_LEVEL)}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GRAY));
                }
            }
        } else if (itemStack.getItem() == Items.CLOCK) {
            ClientLevel level;
            if (((Boolean)BetterTags.CONFIGURATION.showInfoClock.get()).booleanValue() && (level = Minecraft.getInstance().level) != null) {
                event.getToolTip().add(1, Component.translatable((String)"tip.bettertags.clock", (Object[])new Object[]{(int)((level.getDayTime() + 6000L) / 24000L) + 1, BetterTags.getGameTime((Level)level, (Boolean)BetterTags.CONFIGURATION.isTwelves.get())}));
            }
        } else if (itemStack.getItem() == Items.RECOVERY_COMPASS && ((Boolean)BetterTags.CONFIGURATION.showInfoRecovery.get()).booleanValue() && (player = Minecraft.getInstance().player) != null) {
            player.getLastDeathLocation().ifPresent(globalPos -> {
                event.getToolTip().add(1, Component.translatable((String)("biome." + globalPos.dimension().location().toLanguageKey())).withStyle(ChatFormatting.GRAY));
                event.getToolTip().add(2, Component.translatable((String)"tip.coords", (Object[])new Object[]{globalPos.pos().getX(), globalPos.pos().getY(), globalPos.pos().getZ()}).withStyle(ChatFormatting.GRAY));
                event.getToolTip().add(3, Component.translatable((String)"tip.distance", (Object[])new Object[]{String.format(Locale.ROOT, "%2d", BetterTags.distanceTo(player.blockPosition(), globalPos.pos()))}).withStyle(ChatFormatting.GRAY));
            });
        }
        if (((Boolean)BetterTags.CONFIGURATION.showModName.get()).booleanValue() && (st = BetterTags.getModName(itemStack)) != null && !(isFound = event.getToolTip().stream().anyMatch(t -> t.getString().equals(st)))) {
            event.getToolTip().add(Component.literal((String)st).withStyle(ChatFormatting.BLUE));
        }
    }

    private static int distanceTo(BlockPos start, BlockPos end) {
        float f = start.getX() - end.getX();
        float f1 = start.getY() - end.getY();
        float f2 = start.getZ() - end.getZ();
        return (int)Mth.sqrt((float)(f * f + f1 * f1 + f2 * f2));
    }

    @Nullable
    private static String getModName(ItemStack itemStack) {
        String modName = itemStack.getItem().getCreatorModId(itemStack);
        return ModList.get().getModContainerById(modName).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(StringUtils.capitalize((String)modName));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onCommandsRegister(RegisterClientCommandsEvent event) {
        new nbtCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    public static <TYPE> Collection<ResourceLocation> getTags(Stream<TagKey<TYPE>> tags) {
        return tags.map(TagKey::location).collect(Collectors.toUnmodifiableSet());
    }

    private static String getTimeStringShort(int seconds) {
        int days = seconds / 86400;
        int n = seconds % 86400;
        int hours = n / 3600;
        int minutes = (n %= 3600) / 60;
        int secs = n % 60;
        String ss = days != 0 ? String.format("%02d:%02d:%02d:%02d", days, hours, minutes, secs) : (hours != 0 ? String.format("%02d:%02d:%02d", hours, minutes, secs) : String.format("%d:%02d", minutes, secs));
        return ss;
    }

    private static String getGameTime(Level level, boolean isTwelveHour) {
        double ratio = 16.666666666666668;
        int dayTime = (int)((level.getDayTime() + 6000L) % 24000L);
        int hours = dayTime / 1000;
        int minutes = (int)((double)(dayTime % 1000) / ratio);
        String post = "";
        if (isTwelveHour) {
            if (hours >= 12) {
                hours -= 12;
                post = " PM";
            } else {
                post = " AM";
            }
        }
        return (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + post;
    }
}

