/*
 * Decompiled with CFR 0.152.
 */
package wallywhip.BetterTags;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.util.Collection;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import wallywhip.BetterTags.BetterTags;

public class nbtCommands {
    public nbtCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"bettertags").requires(sourceStack -> sourceStack.hasPermission(2))).then(((LiteralArgumentBuilder)Commands.literal((String)"copy").then(Commands.argument((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)40)).then(Commands.argument((String)"tags", (ArgumentType)BoolArgumentType.bool()).executes(context -> nbtCommands.nbtCopy(IntegerArgumentType.getInteger((CommandContext)context, (String)"slot"), BoolArgumentType.getBool((CommandContext)context, (String)"tags")))))).then(Commands.literal((String)"current_item").then(Commands.argument((String)"tags", (ArgumentType)BoolArgumentType.bool()).executes(context -> nbtCommands.nbtCopy(-1, BoolArgumentType.getBool((CommandContext)context, (String)"tags")))))));
    }

    private static int nbtCopy(int slot, boolean showTags) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return 0;
        }
        ItemStack itemStack = slot == -1 ? player.getInventory().getSelected() : player.getInventory().getItem(slot);
        if (itemStack.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"tip.bettertags.empty"), false);
        } else {
            StringBuilder st = new StringBuilder();
            if (!itemStack.getComponents().isEmpty()) {
                itemStack.getComponents().forEach(component -> st.append(component.type()).append(" = ").append(component.value()).append("\n"));
            }
            if (showTags) {
                Block block;
                Collection<ResourceLocation> iTag = BetterTags.getTags(itemStack.getTags());
                if (!iTag.isEmpty()) {
                    st.append("\n").append(Component.translatable((String)"tip.bettertags.item_tags").getString()).append("\n");
                    for (ResourceLocation tag : iTag) {
                        st.append(" #").append(tag.toString()).append("\n");
                    }
                }
                if ((block = Block.byItem((Item)itemStack.getItem())) != Blocks.AIR && !(iTag = BetterTags.getTags(block.defaultBlockState().getTags())).isEmpty()) {
                    st.append(Component.translatable((String)"tip.bettertags.block_tags").getString()).append("\n");
                    for (ResourceLocation tag : iTag) {
                        st.append(" #").append(tag.toString()).append("\n");
                    }
                }
            }
            if (st.isEmpty()) {
                player.displayClientMessage((Component)Component.translatable((String)"tip.bettertags.copied_no", (Object[])new Object[]{itemStack.getHoverName().copy().withStyle(ChatFormatting.DARK_GREEN)}), false);
            } else {
                st.insert(0, itemStack.getHoverName().getString() + "\n" + itemStack.getItemHolder().getRegisteredName() + "\n\n");
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(st.toString()), null);
                player.displayClientMessage((Component)Component.translatable((String)"tip.bettertags.copied", (Object[])new Object[]{itemStack.getHoverName().copy().withStyle(ChatFormatting.DARK_GREEN)}), false);
            }
        }
        return 1;
    }
}

