/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.color;

import com.farcr.nomansland.common.registry.blocks.NMLBlocks;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(modid="nomansland", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ColorHandler {
    @SubscribeEvent
    public static void registerItemColorHandlers(RegisterColorHandlersEvent.Item event) {
        event.register((state, tintIndex) -> GrassColor.get((double)0.5, (double)1.0), new ItemLike[]{(ItemLike)NMLBlocks.GRASS_SPROUTS.get(), (ItemLike)NMLBlocks.FIDDLEHEAD.get(), (ItemLike)NMLBlocks.GROUND_IVY.get()});
        event.register((state, tintIndex) -> tintIndex == 0 ? GrassColor.get((double)0.5, (double)1.0) : 0xFFFFFF, new ItemLike[]{(ItemLike)NMLBlocks.OAT_GRASS.get()});
        event.register((stack, index) -> FoliageColor.get((double)0.5, (double)1.0), new ItemLike[]{(ItemLike)NMLBlocks.MAPLE_LEAVES.get(), (ItemLike)NMLBlocks.WALNUT_LEAVES.get(), (ItemLike)NMLBlocks.APPLE_FRUIT_LEAVES.get(), (ItemLike)NMLBlocks.WILLOW_LEAVES.get()});
    }

    @SubscribeEvent
    public static void registerBlockColorHandlers(RegisterColorHandlersEvent.Block event) {
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageGrassColor((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)NMLBlocks.GRASS_SPROUTS.get(), (Block)NMLBlocks.FIDDLEHEAD.get(), (Block)NMLBlocks.CUT_SUGAR_CANE.get(), (Block)NMLBlocks.FROSTED_GRASS.get(), (Block)NMLBlocks.OAT_GRASS.get(), (Block)NMLBlocks.GROUND_IVY.get()});
        event.register((state, level, pos, tintIndex) -> level != null && pos != null ? BiomeColors.getAverageFoliageColor((BlockAndTintGetter)level, (BlockPos)pos) : GrassColor.get((double)0.5, (double)1.0), new Block[]{(Block)NMLBlocks.MAPLE_LEAVES.get(), (Block)NMLBlocks.WALNUT_LEAVES.get(), (Block)NMLBlocks.APPLE_FRUIT_LEAVES.get(), (Block)NMLBlocks.DUCKWEED.get(), (Block)NMLBlocks.WILLOW_LEAVES.get(), (Block)NMLBlocks.CUT_VINE.get()});
    }

    private static float unpackRed(int rgb) {
        return (float)(rgb >> 16 & 0xFF) / 255.0f;
    }

    private static float unpackGreen(int rgb) {
        return (float)(rgb >> 8 & 0xFF) / 255.0f;
    }

    private static float unpackBlue(int rgb) {
        return (float)(rgb & 0xFF) / 255.0f;
    }

    private static int packColor(float r, float g, float b) {
        return ((int)(Mth.clamp((float)r, (float)0.0f, (float)1.0f) * 255.0f) & 0xFF) << 16 | ((int)(Mth.clamp((float)g, (float)0.0f, (float)1.0f) * 255.0f) & 0xFF) << 8 | (int)(Mth.clamp((float)b, (float)0.0f, (float)1.0f) * 255.0f) & 0xFF;
    }
}

