/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.model;

import com.farcr.nomansland.common.entity.goose.Goose;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GooseModel<T extends Goose>
extends EntityModel<T> {
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart rightWing;
    private final ModelPart leftWing;
    private final ModelPart rightFlightWing;
    private final ModelPart leftFlightWing;

    public GooseModel(ModelPart root) {
        this.root = root;
        this.body = root.getChild("body");
        this.head = this.body.getChild("head");
        this.rightLeg = this.body.getChild("right_leg");
        this.leftLeg = this.body.getChild("left_leg");
        this.rightWing = this.body.getChild("right_wing");
        this.leftWing = this.body.getChild("left_wing");
        this.rightFlightWing = this.body.getChild("right_flight_wing");
        this.leftFlightWing = this.body.getChild("left_flight_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -3.0f, -4.5f, 7.0f, 6.0f, 9.0f), PartPose.offset((float)0.0f, (float)17.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 0).addBox(-1.5f, -10.0f, -2.0f, 3.0f, 12.0f, 3.0f), PartPose.offset((float)0.0f, (float)-1.0f, (float)-3.5f));
        head.addOrReplaceChild("bill", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -1.5f, -3.5f, 2.0f, 3.0f, 2.0f).texOffs(23, 0).addBox(-1.0f, 0.5f, -4.5f, 2.0f, 1.0f, 1.0f), PartPose.offset((float)0.0f, (float)-8.5f, (float)-0.5f));
        body.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(44, 0).mirror().addBox(-1.5f, 0.0f, -2.0f, 3.0f, 4.0f, 2.0f).mirror(false), PartPose.offset((float)-2.0f, (float)3.0f, (float)0.5f));
        body.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(44, 0).addBox(-1.5f, 0.0f, -2.0f, 3.0f, 4.0f, 2.0f), PartPose.offset((float)2.0f, (float)3.0f, (float)0.5f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(46, 0).addBox(0.0f, 0.0f, -4.0f, 1.0f, 5.0f, 8.0f), PartPose.offset((float)3.5f, (float)-3.0f, (float)-0.5f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(46, 0).mirror().addBox(-1.0f, 0.0f, -4.0f, 1.0f, 5.0f, 8.0f).mirror(false), PartPose.offset((float)-3.5f, (float)-3.0f, (float)-0.5f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(41, 13).addBox(-2.5f, 0.0f, 0.0f, 5.0f, 3.0f, 4.0f), PartPose.offset((float)0.0f, (float)-3.0f, (float)4.5f));
        body.addOrReplaceChild("left_flight_wing", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, -0.5f, -1.5f, 17.0f, 1.0f, 7.0f, new CubeDeformation(0.01f)), PartPose.offset((float)3.5f, (float)-2.5f, (float)-3.0f));
        body.addOrReplaceChild("right_flight_wing", CubeListBuilder.create().texOffs(0, 15).mirror().addBox(-17.0f, -0.5f, -1.5f, 17.0f, 1.0f, 7.0f, new CubeDeformation(0.01f)).mirror(false), PartPose.offset((float)-3.5f, (float)-2.5f, (float)-3.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T goose, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.xRot = headPitch * ((float)Math.PI / 180) / 3.0f;
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180) / 3.0f;
        this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (!goose.isInWater()) {
            this.rightWing.zRot = Mth.abs((float)(Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.2f * limbSwingAmount));
            this.leftWing.zRot = Math.min(Mth.cos((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount * -1.0f, Mth.cos((float)(limbSwing * 0.6662f)) * 1.2f * limbSwingAmount);
        }
        this.rightFlightWing.visible = false;
        this.leftFlightWing.visible = false;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.root.getChild("body").render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

