/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.model;

import com.farcr.nomansland.NoMansLand;
import com.farcr.nomansland.common.entity.Moose;
import net.minecraft.client.model.AgeableHierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.entity.animation.json.AnimationHolder;

public class MooseModel
extends AgeableHierarchicalModel<Moose> {
    public static final AnimationHolder STOMP = MooseModel.getAnimation((ResourceLocation)NoMansLand.location("moose/stomp"));
    private final ModelPart root;
    private final ModelPart moose;
    private final ModelPart head;
    private final ModelPart upperbody;
    private final ModelPart lowerbody;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;

    public MooseModel(ModelPart root) {
        super(0.5f, 24.0f);
        this.root = root;
        this.moose = root.getChild("moose");
        this.head = this.moose.getChild("head");
        this.upperbody = this.moose.getChild("upperbody");
        this.lowerbody = this.upperbody.getChild("lowerbody");
        this.rightHindLeg = this.lowerbody.getChild("rightHindLeg");
        this.leftHindLeg = this.lowerbody.getChild("leftHindLeg");
        this.rightFrontLeg = this.upperbody.getChild("rightFrontLeg");
        this.leftFrontLeg = this.upperbody.getChild("leftFrontLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition moose = partdefinition.addOrReplaceChild("moose", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-12.0f, (float)-10.0f));
        PartDefinition head = moose.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 65).addBox(-3.0f, -2.0f, -4.0f, 6.0f, 9.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(50, 0).addBox(-3.0f, -3.0f, -13.0f, 6.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition rightear_r1 = head.addOrReplaceChild("rightear_r1", CubeListBuilder.create().texOffs(10, 41).mirror().addBox(-2.1014f, -9.2713f, -18.0f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)10.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition leftear_r1 = head.addOrReplaceChild("leftear_r1", CubeListBuilder.create().texOffs(10, 41).addBox(0.1014f, -9.2713f, -18.0f, 2.0f, 5.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)10.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition rightantler_r1 = head.addOrReplaceChild("rightantler_r1", CubeListBuilder.create().texOffs(36, 19).mirror().addBox(3.1894f, -23.2791f, -17.5951f, 8.0f, 8.0f, 14.0f, new CubeDeformation(0.1f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)10.0f, (float)0.6151f, (float)-0.0497f, (float)-1.2677f));
        PartDefinition rightantlerconnection_r1 = head.addOrReplaceChild("rightantlerconnection_r1", CubeListBuilder.create().texOffs(33, 41).mirror().addBox(-17.9067f, -2.5333f, -15.929f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.1f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)10.0f, (float)-0.131f, (float)-0.6387f, (float)0.4171f));
        PartDefinition snout_r1 = head.addOrReplaceChild("snout_r1", CubeListBuilder.create().texOffs(0, 65).addBox(-2.0f, -0.0342f, -7.5221f, 4.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)-13.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition leftantler_r1 = head.addOrReplaceChild("leftantler_r1", CubeListBuilder.create().texOffs(36, 19).addBox(-11.1894f, -23.2791f, -17.5951f, 8.0f, 8.0f, 14.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)10.0f, (float)0.6151f, (float)0.0497f, (float)1.2677f));
        PartDefinition leftantlerconnection_r1 = head.addOrReplaceChild("leftantlerconnection_r1", CubeListBuilder.create().texOffs(33, 41).addBox(13.9067f, -2.5333f, -15.929f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)10.0f, (float)-0.131f, (float)0.6387f, (float)-0.4171f));
        PartDefinition dewlap = head.addOrReplaceChild("dewlap", CubeListBuilder.create().texOffs(0, 25).addBox(0.0f, 0.0f, -6.0f, 0.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(48, 66).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)-6.0f));
        PartDefinition upperbody = moose.addOrReplaceChild("upperbody", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, 0.0f, 10.0f, 18.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition lowerbody = upperbody.addOrReplaceChild("lowerbody", CubeListBuilder.create().texOffs(0, 33).addBox(-4.0f, -15.0f, 0.0f, 8.0f, 15.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)18.0f, (float)15.0f));
        PartDefinition tail_r1 = lowerbody.addOrReplaceChild("tail_r1", CubeListBuilder.create().texOffs(0, 41).addBox(-1.0f, -16.5445f, 14.6003f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-13.0f, (float)-5.0f, (float)-0.829f, (float)0.0f, (float)0.0f));
        PartDefinition rightHindLeg = lowerbody.addOrReplaceChild("rightHindLeg", CubeListBuilder.create().texOffs(64, 60).addBox(-1.0f, -3.0f, -3.0f, 3.0f, 14.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-1.0f, 11.0f, -1.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-4.0f, (float)11.0f));
        PartDefinition leftHindLeg = lowerbody.addOrReplaceChild("leftHindLeg", CubeListBuilder.create().texOffs(64, 60).mirror().addBox(-2.0f, -3.0f, -3.0f, 3.0f, 14.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(0, 0).mirror().addBox(-2.0f, 11.0f, -1.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)4.0f, (float)-4.0f, (float)11.0f));
        PartDefinition rightFrontLeg = upperbody.addOrReplaceChild("rightFrontLeg", CubeListBuilder.create().texOffs(50, 41).mirror().addBox(-1.0f, -6.0f, -3.0f, 4.0f, 19.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false).texOffs(35, 0).addBox(0.0f, 13.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)12.0f, (float)5.0f));
        PartDefinition leftFrontLeg = upperbody.addOrReplaceChild("leftFrontLeg", CubeListBuilder.create().texOffs(50, 41).addBox(-3.0f, -6.0f, -3.0f, 4.0f, 19.0f, 6.0f, new CubeDeformation(0.0f)).texOffs(35, 0).mirror().addBox(-3.0f, 13.0f, -2.0f, 3.0f, 11.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)12.0f, (float)5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }

    public void setupAnim(Moose entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.rightHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.animate(entity.stompAnimationState, STOMP, ageInTicks);
    }
}

