/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.client.model.deer;

import com.farcr.nomansland.client.model.deer.DeerModel;
import com.farcr.nomansland.common.entity.deer.Deer;
import com.farcr.nomansland.common.entity.deer.DeerPatternVariant;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tazer.mixed_litter.VariantUtil;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DeerPatternLayer
extends RenderLayer<Deer, DeerModel<Deer>> {
    public DeerPatternLayer(RenderLayerParent<Deer, DeerModel<Deer>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Deer deer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        DeerPatternVariant variant = null;
        for (Holder mobVariantHolder : VariantUtil.getVariants((Mob)deer, (LevelAccessor)deer.level())) {
            DeerPatternVariant patternVariant;
            Object object = mobVariantHolder.value();
            if (!(object instanceof DeerPatternVariant)) continue;
            variant = patternVariant = (DeerPatternVariant)((Object)object);
            break;
        }
        if (variant != null && !deer.isInvisible()) {
            ResourceLocation texture = deer.isBaby() ? variant.babyTexture : variant.texture;
            VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.entityTranslucent((ResourceLocation)texture.withPath(path -> "textures/" + path + ".png")));
            ((DeerModel)this.getParentModel()).renderToBuffer(poseStack, vertexconsumer, packedLight, LivingEntityRenderer.getOverlayCoords((LivingEntity)deer, (float)0.0f));
        }
    }
}

