/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class PathBlock
extends DirtPathBlock {
    public final Block mainBlock;
    public final boolean hasGravity;

    public PathBlock(BlockBehaviour.Properties properties, Block mainBlock, boolean hasGravity) {
        super(properties);
        this.mainBlock = mainBlock;
        this.hasGravity = hasGravity;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return !this.defaultBlockState().canSurvive((LevelReader)pContext.getLevel(), pContext.getClickedPos()) ? Block.pushEntitiesUp((BlockState)this.defaultBlockState(), (BlockState)this.mainBlock.defaultBlockState(), (LevelAccessor)pContext.getLevel(), (BlockPos)pContext.getClickedPos()) : super.getStateForPlacement(pContext);
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (this.hasGravity && FallingBlock.isFree((BlockState)pLevel.getBlockState(pPos.below()))) {
            pLevel.scheduleTick(pPos, (Block)this, 2);
        }
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == Direction.UP && !pState.canSurvive((LevelReader)pLevel, pCurrentPos)) {
            pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
        }
        if (this.hasGravity && FallingBlock.isFree((BlockState)pLevel.getBlockState(pCurrentPos.below()))) {
            pLevel.scheduleTick(pCurrentPos, (Block)this, 2);
        }
        return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pSource) {
        this.turnToBlock(null, pState, (Level)pLevel, pPos);
    }

    public void turnToBlock(@Nullable Entity pEntity, BlockState pState, Level pLevel, BlockPos pPos) {
        BlockState blockstate = PathBlock.pushEntitiesUp((BlockState)pState, (BlockState)this.mainBlock.defaultBlockState(), (LevelAccessor)pLevel, (BlockPos)pPos);
        pLevel.setBlockAndUpdate(pPos, blockstate);
        pLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pPos, GameEvent.Context.of((Entity)pEntity, (BlockState)blockstate));
    }
}

