/*
 * Decompiled with CFR 0.152.
 */
package com.farcr.nomansland.common.block;

import com.farcr.nomansland.NMLConfig;
import com.farcr.nomansland.common.registry.NMLDamageTypes;
import com.farcr.nomansland.common.registry.NMLSounds;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SpikeTrapBlock
extends DirectionalBlock
implements SimpleWaterloggedBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final MapCodec<SpikeTrapBlock> CODEC = SpikeTrapBlock.simpleCodec(SpikeTrapBlock::new);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape UP_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape DOWN_AABB = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SpikeTrapBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)POWERED, (Comparable)Boolean.TRUE));
    }

    protected MapCodec<? extends DirectionalBlock> codec() {
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> UP_AABB;
            case Direction.NORTH -> NORTH_AABB;
            case Direction.SOUTH -> SOUTH_AABB;
            case Direction.WEST -> WEST_AABB;
            case Direction.EAST -> EAST_AABB;
            case Direction.DOWN -> DOWN_AABB;
        };
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, neighborState, level, pos, neighborPos);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        if (!neighborBlock.equals(state.getBlock()) && !level.isClientSide) {
            this.checkIfPowered(level, pos, state);
        }
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        block4: {
            LivingEntity livingEntity;
            block5: {
                if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isAlive() || ((Boolean)state.getValue((Property)POWERED)).booleanValue()) break block4;
                if (!(livingEntity instanceof Player)) break block5;
                Player player = (Player)livingEntity;
                if (player.getAbilities().invulnerable) break block4;
            }
            if (!livingEntity.isShiftKeyDown() || !livingEntity.getPosition(0.0f).equals((Object)livingEntity.getPosition(1.0f))) {
                livingEntity.hurt(NMLDamageTypes.getSimpleDamageSource(level, NMLDamageTypes.SPIKE_POKE), ((Double)NMLConfig.POKING_DAMAGE.get()).floatValue());
            }
        }
    }

    private void checkIfPowered(Level level, BlockPos pos, BlockState state) {
        boolean hasSignal = false;
        for (Direction d : Direction.values()) {
            if (!level.hasSignal(pos.relative(d), d)) continue;
            hasSignal = true;
            break;
        }
        if (hasSignal && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(true)));
            level.playSound(null, pos, (SoundEvent)NMLSounds.SPIKE_TRAP_RETRACT.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            level.gameEvent((Holder)GameEvent.BLOCK_DEACTIVATE, pos, GameEvent.Context.of((BlockState)state));
        } else if (!hasSignal && ((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
            level.playSound(null, pos, (SoundEvent)NMLSounds.SPIKE_TRAP_EXTEND.get(), SoundSource.BLOCKS, 0.5f, 1.0f);
            level.gameEvent((Holder)GameEvent.BLOCK_ACTIVATE, pos, GameEvent.Context.of((BlockState)state));
            Predicate<LivingEntity> livingEntityPredicate = LivingEntity::isAlive;
            List entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(pos), livingEntityPredicate);
            if (!entities.isEmpty()) {
                entities.forEach(entity -> entity.hurt(NMLDamageTypes.getSimpleDamageSource(level, NMLDamageTypes.SPIKE_IMPALE), ((Double)NMLConfig.IMPALING_DAMAGE.get()).floatValue()));
            }
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallingDistance) {
        if (state.getValue((Property)FACING) == Direction.UP && !((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
            entity.causeFallDamage(fallingDistance + 2.0f, ((Double)NMLConfig.FALLING_DAMAGE.get()).floatValue(), NMLDamageTypes.getSimpleDamageSource(level, NMLDamageTypes.SPIKE_FALL));
        } else {
            super.fallOn(level, state, pos, entity, fallingDistance);
        }
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        Predicate<LivingEntity> livingEntityPredicate;
        List entities;
        if (!oldState.is(state.getBlock()) && !level.isClientSide) {
            this.checkIfPowered(level, pos, state);
        }
        if (isMoving && !((Boolean)state.getValue((Property)POWERED)).booleanValue() && !(entities = level.getEntitiesOfClass(LivingEntity.class, new AABB(pos), livingEntityPredicate = LivingEntity::isAlive)).isEmpty()) {
            entities.forEach(entity -> entity.hurt(NMLDamageTypes.getSimpleDamageSource(level, NMLDamageTypes.SPIKE_SKEWER), ((Double)NMLConfig.SKEWERING_DAMAGE.get()).floatValue()));
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return (Boolean)state.getValue((Property)POWERED);
    }
}

